<?php

	include 'header.php';
	include 'navbar.php';

	require_once('includes/API_Config.php');
	$obj = new API_Config;
	$data = array();
	$data['refer_id'] = $_SESSION['refer_id'];
	$data['user_id']  = $_SESSION['user_id'];
	$response         = json_decode($obj->call_API("API_PVBalance.php", $data));
	$balance	      = $response->data->pv_balance;

?>


	<div class="row">
		<div class="col-md-12 grid-margin">
			<div class="card">
				<div class="card-body">
					<h3 class="card-title mb-0">Withdraw Fund</h3>
					<p>&nbsp;</p>
					<div class="row">
							<div class="col-md-12">
							<section>
							<form id="frmWithdraw" method="post">
								<div class="row">
									<div class="form-group col-md-4">
									  <label>Amount to be withdraw *:</label>
									  <input type="text" name="pvWithdraw" id="pvWithdraw" class="form-control" required aria-invalid="true" aria-describedby="pvWithdrawHelp" placeholder="Enter PV">
									  <small id="pvWithdrawHelp" class="form-text text-muted"></small>
									</div>
								</div>
								<div class="row">
									<div class="form-group col-md-4">
									  <label>Transaction Password:</label>
									  <input type="password" name="withdrawPassword" id="withdrawPassword" class="form-control" required aria-invalid="true" aria-describedby="withdrawPasswordHelp" placeholder="Enter your transaction password">
									  <small id="withdrawPasswordHelp" class="form-text text-muted"></small>
									</div>
								</div>
								<div class="row">
									 <div class="table-responsive">
										<table class="table">
										  <thead>
											<tr>
											  <th>Withdrawal Particulars</th>
											  <th>Amount</th>
											</tr>
										  </thead>
										  <tbody>
											<tr>
											  <td>PV Balance</td>
											  <td>
												<?php 
													if(empty($balance)) echo number_format("0", 2);
																
													else
														echo number_format($balance, 2);
												?> PV
											  </td>
											</tr>
											<tr>
											  <td>Preferred Payment Method</td>
											  <td>Bank Account</td>
											</tr>
											<tr>
											  <td>Processing / Admin Charges</td>
											   <td>
												<?php 
													if(empty($balance)) echo number_format("0", 2);
																
													else
														echo number_format($balance*0.05, 2);
												?> PV (5% Applicable)
											   </td>
											</tr>
										 </tbody>
										</table>
									  </div>
								</div>
								<p>&nbsp;</p>
								<!--div class="row">
									<div class="form-group col-md-6">
										<button type="button" class="btn btn-primary btn-fw" id="btnWithdraw"  name="btnWithdraw" 
										<?php
											//if(empty($balance)) echo "disabled";?>>Submit</button-->
									</div>
								</div>
							</form>
							</section>
							 </div>                         
						 </div>
                      </div>



				</div>
			</div>
		</div>
	</div>


<?php
	include 'footer.php';
?>


 <script>
   
   var balance = <?php echo $balance;?>;

  
	$("#btnWithdraw").click(function(){


		$("#frmWithdraw").validate({
			  rules: {
				pvWithdraw: {
				  required: true,
				  digits: true
				},
				withdrawPassword: {
				  required: true,
				  minlength: 6,
				}
			  },
			  messages: {
				pvWithdraw: {
				  required: "Please enter the withdraw amount.",
		    	  digits:  "Please enter a valid amount.",
				},
				withdrawPassword: {
				  required: "Please enter the transaction password.",
  		    	  minlength: "Transaction Password must be of atleast 6 characters.",
				}
			  },
			  errorPlacement: function(label, element) {
				label.addClass('mt-2 text-danger');
				label.insertAfter(element);
			  },
			  highlight: function(element, errorClass) {
				$(element).parent().addClass('has-danger')
				$(element).addClass('form-control-danger')
			  }

		 });

		 if($("#frmWithdraw").valid())
		 {
			 $("#frmWithdraw").submit();
			 
		 }

		 else
			 return false;


	});



	/*$("#frmWithdraw").on('submit',(function(event){

		   event.preventDefault();
		   $("btnWithdraw").hide();
		   $("#profileloader").show();

		  $.ajax({
			type        : 'POST', 
			url         : '../API/API_withdrawrequest.php', 
			data        : new FormData(this),
			dataType    : 'json', 
			encode      : true,
			cache		: false,
			contentType : false,
			processData : false,
		  })

		  .done(function(data){
		
			if (data.success) { 
				location.reload();
				alert(data.message);
			}

			else{
				alert(data.message);
			} 

		  }) 

		 .fail(function(data){
			  location.reload();
 			  $("#btnWithdraw").show();
			  $("#profileloader").hide();
			  alert(data.message);
		  });

	}));*/




</script>

</body>
</html>