<?php

	include 'header.php';
	include 'navbar.php';
	
	require_once('includes/API_Config.php');
    
	$obj = new API_Config;
	$data = array();
	$data['refer_id'] = $_SESSION['refer_id'];
	$data['user_id'] = $_SESSION['user_id'];
	$response = json_decode($obj->call_API("API_getPurchaseList.php", $data));
	error_reporting(0);
?>


	  <div class="card">
		<div class="card-body">
		   <form id="frmBankSlip" method="post" enctype="multipart/form-data">
				<div class="row">
					<div class="form-group offset-md-4 col-md-4">
		   				<h4 class="card-title">Upload Bank Payment Slip</h4>
					</div>
				</div>
				<div class="row">
					<div class="form-group offset-md-4 col-md-4">
					  <label>Order ID:</label>
					  <input type="text" name="order_id" id="order_id" class="form-control" value="<?php echo $_GET['order'];?>" readonly/>
					  <small id="oldPasswordHelp" class="form-text text-muted"></small>
					</div>
				</div>
                <div class="row">
				  <div class="form-group offset-md-4 col-md-4">
             		<input type="file" class="dropify" name="bankSlip" id="bankSlip" data-max-file-size="5M" data-allowed-file-extensions="pdf png jpeg jpg" accept="image/png, image/jpg, image/jpeg, application/pdf">
				  </div>
                </div>
			    <div class="row">
					<div class="form-group offset-md-4 col-md-4">
						<button type="submit" class="btn btn-primary btn-fw" id="btnUploadSlip">Submit</button>
						<input type="text" name="refer_id" id="refer_id" class="form-control" value="<?php echo $_SESSION['refer_id'];?>" hidden/>
					</div>
			    </div>
			    <div class="dot-opacity-loader" id="profileloader">
				  <span></span>
				  <span></span>
				  <span></span>
			    </div>
		   </form>
		</div>
	  </div>


	  <script type="text/javascript">

			$("#btnUploadSlip").click(function(){

				$("#frmBankSlip").validate({
				  rules: {
					bankSlip: {
					  required: true,
					},
					order_id: {
					  required: true,
					}
				  },
				  messages: {
					bankSlip: {
					  required: "Please upload your Bank Deposit Slip!",
					},
					order_id: {
					  required: "Order ID is missing!",
					}					
				  },
				  errorPlacement: function(label, element) {
					label.addClass('mt-2 text-danger');
					label.insertAfter(element);
				  },
				  highlight: function(element, errorClass) {
					$(element).parent().addClass('has-danger')
					$(element).addClass('form-control-danger')
				  }

			   });

			   if($("#frmBankSlip").valid())
			   {
					$("#frmBankSlip").submit();
			   }

			   else
				   return false;

			});

			
		    $("#frmBankSlip").on('submit',(function(event){
				
				  event.preventDefault();
				  $("#btnUploadSlip").hide();
				  $("#profileloader").show();

				  $.ajax({
					type        : 'POST', 
					url         : '../API/API_uploadPackageSlip.php', 
					data        : new FormData(this),
					dataType    : 'json', 
					encode      : true,
					cache		: false,
					contentType : false,
					processData : false,
				  })

				  .done(function(data){
					$("#btnUploadSlip").show();
					$("#profileloader").hide();

					if (data.success) { 
						alert(data.message);
						window.location.href = "my-purchases.php";

					}

					else{
						 alert(data.message);
					} 

				  }) 

				  .fail(function(data){
					  $("#btnUploadSlip").show();
					  $("#profileloader").hide();
					  alert(data.message);
				   });


			}));




	  </script>


<?php
	include 'footer.php';
?>