<?php

	include 'header.php';
	include 'navbar.php';

?>
		<div class="row">
						<div class="col-12 grid-margin">
						  <div class="card card-statistics">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Support</h4>
                  <form class="cmxform" id="frmSupport" method="post" action="#">
                    <fieldset>
					<div class="row">

                      <div class="form-group col-md-2">
                        <label for="memberID">Member ID:</label>
                        <input id="memberID" class="form-control" name="memberID" type="text" value="<?php echo $_SESSION['refer_id'];?>" readonly>
                      </div>
                     </div>
					  
					  <div class="row">
						  <div class="form-group col-md-3">
							<label for="mobileNumber">Mobile Number:</label>
							<input id="mobileNumber" class="form-control" name="mobileNumber" maxlength='10' value="<?php echo '+91' . $_SESSION['mobile_number'];?>" type="text">
						  </div>
						  <div class="form-group col-md-3">
							<label for="email">Email:</label>
							<input id="email" class="form-control" name="email" type="email" value="<?php echo $_SESSION['email_address'];?>" required>
						  </div>
					  </div>

  					  <div class="row">

						  <div class="form-group col-md-3">
							   <label>Select Subject:</label>
							   <select name="cmbSubject" id="cmbSubject" class="form-control" required>
									<option value="1">Edit Profile/Upload KYC</option>
									<option value="2">Reset Transaction Password</option>
									<option value="3">Change Sponsor ID</option>
									<option value="4">Product Purchase</option>
									<option value="5">Product Dispatch</option>
									<option value="6">Product Payment</option>
									<option value="7">Incentive</option>
									<option value="8">Reward Claim</option>
									<option value="9">Others</option>
								</select>
						  </div>

						</div>
					  <div class="form-group col-md-5">
                        <label for="enquiry">Query Description:</label>
						<textarea id="enquiry" name="enquiry" class="form-control" cols="60" rows="5" placeholder="Ask your query!"></textarea>
						<input type="text" id="subject" class="form-control" name="subject" style="display:none;">

                      </div>
                      <input class="btn btn-primary" type="button" value="Submit" id="btnSupport">
					  <div class="dot-opacity-loader" id="supportLoader" style="display:none;" aria-hidden="true">
						  <span></span>
						  <span></span>
						  <span></span>
					   </div>
                    </fieldset>
                  </form>
                </div>
              </div>
            </div>
          </div>

            </div>
          </div>



	<script type="text/javascript">

	$(document).ready(function() { 



			$("#frmSupport").on('submit',(function(event){


				 event.preventDefault();
			     event.stopImmediatePropagation();

				 $("#supportLoader").css("display","");
				 $("#btnSupport").css("display","none");
				 $("#subject").val($('#cmbSubject').find('option:selected').text());

				

				  $.ajax({
					type        : 'POST', 
					url         : '../mailer/API_support_request.php', 
					data        : new FormData(this),
					dataType    : 'json', 
					encode      : true,
					cache		: false,
					contentType : false,
					processData : false,
				  })

				  .done(function(data){
					$("#supportLoader").css("display","none");
					$("#btnSupport").css("display","");


					if(data.success) { 
						location.reload();
						alert(data.message);
					}

					else{
						alert(data.message);
						location.reload();

					} 

				  }) 

				 .fail(function(data){
					  location.reload();
					  $("#supportLoader").css("display","none");
					  $("#btnSupport").css("display","");
					  alert(data.message);
				  });



		  
			 }))


			$("#btnSupport").click(function(){


					$("#frmSupport").validate({
					  rules: {
					   mobileNumber: {
							required: true,
        					digits: true,
							minlength: 10,
			
                        },
						email: {
							required: true,
        						
                        },
						enquiry: {
							required: true,
    						
                        },



					  },
					  messages: {
						mobileNumber:{
							required: 'Please enter mobile number.',
							digits:   'Please enter a valid mobile number.',
							minlength: 'Please enter a valid mobile number.'
						},
						 email:{
							required: 'Please enter email address.',
						},
						 enquiry:{
							required: 'Please enter query description.',
						}
					  },
					  errorPlacement: function(label, element) {
						label.addClass('mt-2 text-danger');
						label.insertAfter(element);
					  },
					  highlight: function(element, errorClass) {
						$(element).parent().addClass('has-danger')
						$(element).addClass('form-control-danger')
					  }

				   });


				   if($("#frmSupport").valid())
				   {
					   $("#frmSupport").submit();
					   return true;
				   }

				   else
					   return false;

			 });

		});


		


	</script>




<?php
	include 'footer.php';

	
?>