<?php
	include 'header.php';
	include 'navbar.php';

	require_once('includes/API_Config.php');
    
	$obj = new API_Config;
	$data = array();
	$data['refer_id'] = $_SESSION['refer_id'];
	$data['user_id'] = $_SESSION['user_id'];
	$response = json_decode($obj->call_API("API_getProfile.php", $data));
	$profile = $response->profile_data[0];
?>


	<div class="col-md-12 grid-margin stretch-card">
		  <div class="card">
			<div class="card-body">
			  <h4 class="card-title">Profile</h4>
				<div class="col-md-12 pl-md-5 pt-4 pt-md-0">
                      <ul class="nav nav-tabs tab-basic" role="tablist">
                        <li class="nav-item">
                          <a class="nav-link active" id="personal-tab" data-toggle="tab" href="#personal" role="tab" aria-controls="personal" aria-selected="true">Personal</a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="address-tab" data-toggle="tab" href="#address" role="tab" aria-controls="address" aria-selected="false">Address</a>
                        </li>
						<li class="nav-item">
                          <a class="nav-link" id="bank-tab" data-toggle="tab" href="#bank" role="tab" aria-controls="bank" aria-selected="false">Bank</a>
                        </li>

                      </ul>
                 
					  
    				<form id="frmEditProfile" method="post" enctype="multipart/form-data">
					  <div class="tab-content tab-content-basic">
                        <div class="tab-pane fade show active" id="personal" role="tabpanel" aria-labelledby="personal-tab">
							<div class="row">
								<div class="form-group col-md-3">
								  <label>First Name: *</label>
								  <input type="text" name="firstName" id="firstName" class="form-control" required aria-invalid="true" aria-describedby="firstNameHelp" placeholder="Enter First Name" value="<?php echo $profile->name;?>" readonly>
								  <small id="firstNameHelp" class="form-text text-muted"></small>
								</div>
								<div class="form-group col-md-3">
								  <label>Last Name: *</label>
								  <input type="text" name="lastName" id="lastName" class="form-control" placeholder="Last Name" value="<?php echo $profile->last_name;?>" readonly>
								  <small id="lastNameHelp" class="form-text text-muted"></small>
								</div>
							</div>
							<div class="row">
								<div class="form-group col-md-3">
								  <label>Gender: *</label>
								  <select class="form-control gender" id="selectGender" name="selectGender" disabled>
									  <option value="Male" <?php if($profile->gender=="Male") echo "Selected";?>>Male</option>
									  <option value="Female" <?php if($profile->gender=="Female") echo "Selected";?>>Female</option>
								  </select>
								</div>
								<div class="form-group col-md-3">
								  <label>Date of Birth:*</label>
								  <input class="form-control" id="dob" name="dob" data-inputmask="'alias': 'date'" value="<?php echo date("d/m/Y", strtotime($profile->dob));?>" readonly>
								</div>
							</div>
							<div class="row">
								<div class="form-group col-md-3">
									  <label>Mobile Number: *</label><br/>
									  <input type="tel" name="mobileNumber" id="mobileNumber" class="form-control col-md-12" placeholder="Mobile Number" maxlength="10" value="+<?php echo  $profile->country_code . $profile->mobile_number;?>" readonly>
								</div>
								<div class="form-group col-md-3">
								  <label>Email Address: *</label>
								  <input type="email" name="emailID" id="emailID" class="form-control" placeholder="Email Address" type="email" value="<?php echo $profile->email_address;?>" readonly>
								</div>
							</div>

                        </div>


                        <div class="tab-pane fade" id="address" role="tabpanel" aria-labelledby="address-tab">
                            <div class="row">
								<div class="form-group col-md-4">
								  <label>Address Line1:</label>
								  <input type="text" name="addressLine1" id="addressLine1" class="form-control" required aria-invalid="true" aria-describedby="addressLine1Help" placeholder="Enter Address Line1" value="<?php echo $profile->address1;?>" readonly>
								  <small id="addressLine1Help" class="form-text text-muted"></small>
								</div>
								<div class="form-group col-md-4">
								  <label>Address Line2:</label>
								  <input type="text" name="addressLine2" id="addressLine2" class="form-control" placeholder="Enter Address Line2" value="<?php echo $profile->address2;?>" readonly>
								  <small id="addressLine2Help" class="form-text text-muted"></small>
								</div>
							</div>
							<div class="row">
								<div class="form-group col-md-4">
								  <label>Zip Code:</label>
								  <input type="text" name="zipCode" id="zipCode" class="form-control" required aria-invalid="true" aria-describedby="zipCodeHelp" placeholder="Enter a Zip Code" value="<?php echo $profile->zip_code;?>" readonly>
								  <small id="zipCodeHelp" class="form-text text-muted"></small>
								</div>
								<div class="form-group col-md-4">
								  <label>Country:</label>
								  <input type="text" name="country" id="country" class="form-control" placeholder="Enter the country name" value="<?php if(empty($profile->country)) echo "India"; else echo $profile->country;?>" readonly>
								  <small id="countryHelp" class="form-text text-muted"></small>
								</div>
							</div>
							<div class="row">
								<div class="form-group col-md-4">
								  <label>State:</label>
								  <input type="text" name="state" id="state" class="form-control" required aria-invalid="true" aria-describedby="stateHelp" placeholder="Enter the state name" value="<?php echo $profile->state;?>" readonly>
								  <small id="stateHelp" class="form-text text-muted"></small>
								</div>
								<div class="form-group col-md-4">
								  <label>City:</label>
								  <input type="text" name="city" id="city" class="form-control" placeholder="Enter the city name" value="<?php echo $profile->city;?>" readonly>
								  <small id="cityHelp" class="form-text text-muted"></small>
								</div>
							</div>
				        </div>



						<div class="tab-pane fade" id="bank" role="tabpanel" aria-labelledby="bank-tab">
                             <div class="row">
								<div class="form-group col-md-3">
								  <label>Account Number:</label>
								  <input type="text" name="accountNo" id="accountNo" class="form-control" required aria-invalid="true" aria-describedby="accountNoHelp" placeholder="Enter Account Number" value="<?php echo $profile->account_number;?>" readonly>
								  <small id="accountNoHelp" class="form-text text-muted"></small>
								</div>
								<div class="form-group col-md-3">
								  <label>Bank Name:</label>
								  <input type="text" name="bankName" id="bankName" class="form-control" placeholder="Enter Bank Name" value="<?php echo $profile->bank_name;?>" readonly>
								  <small id="bankNameHelp" class="form-text text-muted"></small>
								</div>
							</div>
							<div class="row">
								<div class="form-group col-md-3">
								  <label>Swift Code: (optional)</label>
								  <input type="text" name="swiftCode" id="swiftCode" class="form-control" aria-invalid="true" aria-describedby="swiftCodeHelp" placeholder="Enter a Swift Code" value="<?php echo $profile->swift_code;?>" readonly>
								  <small id="swiftCodeHelp" class="form-text text-muted"></small>
								</div>
								<div class="form-group col-md-3">
								  <label>IFSC Code:</label>
								  <input type="text" name="ifscCode" id="ifscCode" class="form-control" placeholder="Enter IFSC Code" value="<?php echo $profile->ifsc_code;?>" readonly>
								  <small id="ifscCodeHelp" class="form-text text-muted"></small>
								</div>
							</div>
				        </div>

						<br/>

						<div class="row">
						    <div class="form-group col-md-3 dot-opacity-loader" id="profileloader">
								<span></span>
								<span></span>
								<span></span>
							</div>
						</div>               

						<div class="row">
							<div class="form-group col-md-6">
								<button type="submit" class="btn btn-primary btn-fw" id="btnEditProfile">Edit</button>
								<input type="text" name="section" id="section" class="form-control" hidden/>
								<input type="text" name="txtAuthenticate" id="txtAuthenticate" class="form-control" hidden/>
							</div>
					    </div>
	

						</form>

			   </div>
		  </div>
		</div>
	  </div>
	</div>

	<div class="modal fade" id="otpProfileModal" tabindex="-1" role="dialog" aria-labelledby="ProfileModal" style="display:none;" aria-hidden="true">
	   <div class="modal-dialog" role="document">
		 <div class="modal-content">
			
			<div class="modal-header">
			  <h5 class="modal-title" id="otpProfileModal">Enter Your Transaction Password</h5>
			</div>

			<div class="modal-body">
			  <form id="frmOTPProfile" action="" method="POST" enctype="multipart/form-data">
				<div class="row">
					<div class="form-group col-md-12">
					  <input type="password" name="profileTransactionPassword" id="profileTransactionPassword" class="form-control" required aria-invalid="true" aria-describedby="profileTransactionPasswordHelp" placeholder="Enter Your Transaction Password">
					  <small id="profileTransactionPasswordHelp" class="form-text text-muted"></small>
					</div>
				</div>
			   </form>
			</div>

			<div class="modal-footer">
			  <button type="button" class="btn btn-primary" id="btnOTPProfile">Submit</button>
			  <button type="button" class="btn btn-light" id="closeModal" data-dismiss="modal">Close</button>
			</div>

		</div>
	  </div>
   </div>


  <script src="../js/formpickers.js"></script>
  <script src="../js/formpickers.js"></script>
  <script src="../js/form-addons.js"></script>
  <script src="../js/x-editable.js"></script>
  <?php
		include 'footer.php';
   ?>




<script>


	   $(".cancel").click(function(){

			 location.reload();

	   });

	   $("#personal-tab, #address-tab, #bank-tab").click(function(){
		   disableField();
		   $("#btnEditProfile").text("Edit");

	   });



	    function enableField()
		{
			//$('#firstName').removeAttr("readonly");
			//$('#lastName').removeAttr("readonly");
			//$('#mobileNumber').removeAttr("readonly");
			//$('#emailID').removeAttr("readonly");
			//$('#selectGender').removeAttr("readonly");
			$('#dob').removeAttr("readonly");
			//$('#selectGender').removeAttr("disabled");
			$('#addressLine1').removeAttr("readonly");
			$('#addressLine2').removeAttr("readonly");
			$('#zipCode').removeAttr("readonly");
			$('#country').removeAttr("readonly");
			$('#state').removeAttr("readonly");
			$('#city').removeAttr("readonly");
			$('#accountNo').removeAttr("readonly");
			$('#bankName').removeAttr("readonly");
			$('#swiftCode').removeAttr("readonly");
			$('#ifscCode').removeAttr("readonly");
	    }


		function disableField()
		{
			
			$('#firstName').attr("readonly", "readonly");
			$('#lastName').attr("readonly", "readonly");
			$('#mobileNumber').attr("readonly", "readonly");
			$('#emailID').attr("readonly", "readonly");
			$('#selectGender').attr("readonly", "readonly");
			$('#dob').attr("readonly", "readonly");
			$('#selectGender').attr("disabled", "disabled");
			$('#addressLine1').attr("readonly", "readonly");
			$('#addressLine2').attr("readonly", "readonly");
			$('#zipCode').attr("readonly", "readonly");
			$('#country').attr("readonly", "readonly");
			$('#state').attr("readonly", "readonly");
			$('#city').attr("readonly", "readonly");
			$('#accountNo').attr("readonly", "readonly");
			$('#bankName').attr("readonly", "readonly");
			$('#swiftCode').attr("readonly", "readonly");
			$('#ifscCode').attr("readonly", "readonly");
		}



		 $("#btnEditProfile").click(function(){


			if($("#btnEditProfile").text() == "Edit")
			{
				$("#btnEditProfile").text("Save");
				$("#btnCancel").removeAttr("hidden");
				enableField();
			    return false;

			}


			else
		    {
				$("#frmEditProfile").validate({
				  rules: {
					firstName: {
					  required: true,
					  minlength: 3
					},
					lastName: {
					  required: true,
					  minlength: 3
					},
					mobileNumber:{
					required: true,
					digits: true,
					minlength: 6,
					},
					emailID: {
					  required: true,
					  email: true
					},
					dob:{
					  required: true,
					},
					addressLine1: {
					  required: true,
					},
					addressLine2: {
					  required: true,
					},
				    country: {
					  required: true,
					},
					zipCode: {
					  required: true,
					},
					state: {
					  required: true,
					},
					city: {
					  required: true,
					},
					
				  },
				  messages: {
					firstName: {
					  required: "Please enter a First Name",
					  minlength: "First Name must consist of at least 3 characters"
					},
					lastName: {
					  required: "Please enter a username",
					  minlength: "Last Name must consist of at least 3 characters"
					},
					mobileNumber:{
					  required: 'Please provide mobile number.',
					  digits:'Please enter a valid mobile number.',
					  minlength: "Please enter valid mobile number."
					},					
					emailID: "Please enter a valid email address.",
                    dob: "Please enter a date of birth.",
					addressLine1: {
					  required: "Please enter address line 1.",
					},
					addressLine2: {
					  required: "Please enter address line 2.",
					},
					country: {
					  required: "Please enter the country name.",
					},
					zipCode: {
					  required: "Please enter the zip code.",
					},
					state: {
					  required: "Please enter the state name.",
					},
				    city: {
					  required: "Please enter the city name.",
					}
				  },
				  errorPlacement: function(label, element) {
					label.addClass('mt-2 text-danger');
					label.insertAfter(element);
				  },
				  highlight: function(element, errorClass) {
					$(element).parent().addClass('has-danger')
					$(element).addClass('form-control-danger')
				  }

			   });

			   if($("#frmEditProfile").valid())
			   {
				   //$("#frmEditProfile").submit();
			       $('#otpProfileModal').modal('show');
				   return false;

			   }

			   else
				   return false;


			}

	  });



	  $("#frmEditProfile").on('submit',(function(event){


   		  $("#btnEditProfile").attr("disabled","disabled").css("cursor","wait");
		
		  event.preventDefault();
          $("#btnEditProfile").hide();
	      $("#profileloader").show();

		  var section = 0;

		  if($("div#personal").hasClass('active'))
			 section = 1;

		  else if($("div#address").hasClass('active'))
			 section = 2;

		  else if($("div#bank").hasClass('active'))
			 section = 3;


		  $("#section").val(section);


	    	  $.ajax({
				type        : 'POST', 
				url         : '../API/API_updateProfile.php', 
				data        : new FormData(this),
				dataType    : 'json', 
				encode      : true,
				cache		: false,
				contentType : false,
				processData : false,
			  })

			  .done(function(data){
				$("#btnSubmit").show();
				$("#profileloader").hide();

				if (data.success) { 
					alert(data.message);
					$("#btnSubmit").text("Edit");
					disableField();
					location.reload();
				}

				else{
					 alert(data.message);
					 location.reload();

				}

				$("#btnEditProfile").removeAttr("disabled").css("cursor","pointer");;
			  })

			  .fail(function(data){
				  $("#btnSubmit").show();
				  $("#profileloader").hide();
				  alert(data.message);
				  //location.reload();
      			  $("#btnEditProfile").removeAttr("disabled").css("cursor","pointer");;
			   });


	 }));



	 $("#btnOTPProfile").click(function(){

			$("#frmOTPProfile").validate({
			  rules: {
				profileTransactionPassword: {
					required: true,
					minlength: 6
				}
			  },
			  messages: {
				profileTransactionPassword:{
					required: 'Please enter your transaction password.',
					minlength: 'Transaction password must be of atleast 6 characters.'
				}
			  },
			  errorPlacement: function(label, element) {
				label.addClass('mt-2 text-danger');
				label.insertAfter(element);
			  },
			  highlight: function(element, errorClass) {
				$(element).parent().addClass('has-danger')
				$(element).addClass('form-control-danger')
			  }

		   });

		   if($("#frmOTPProfile").valid())
		   {
			   $("#txtAuthenticate").val($("#profileTransactionPassword").val());
			   $("#frmOTPProfile").submit();
			   return true;

		   }

		   else
			   return false;

	 });


	 $("#frmOTPProfile").on('submit',(function(event){

		   $('#closeModal').trigger('click');
		   $("#frmEditProfile").submit();

	 }));



</script>

</body>
</html>