<?php
	include 'header.php';
	include 'navbar.php';

	require_once('includes/API_Config.php');
    
	$obj = new API_Config;
	$data = array();
	$data['refer_id'] = $_SESSION['refer_id'];
	$data['user_id'] = $_SESSION['user_id'];
	$response = json_decode($obj->call_API("API_getProfile.php", $data));
	$profile = $response->profile_data[0];
?>



	<div class= "row">

			<div class="col-md-12 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">My Profile</h4>
                  <div class="vertical-tab">

                    
					<ul class="nav nav-tabs tab-solid tab-solid-info mr-4 col-md-2" role="tablist">
                      <li class="nav-item">
                        <a class="nav-link active show" id="tab-1" data-toggle="tab" href="#personal" role="tab" aria-controls="profile-6-1" aria-selected="true">Personal</a>
                      </li>
                      <li class="nav-item">
                        <a class="nav-link" id="tab-2" data-toggle="tab" href="#address" role="tab" aria-controls="profile-6-2" aria-selected="false">Address</a>
                      </li>
                      <li class="nav-item">
                        <a class="nav-link" id="tab-3" data-toggle="tab" href="#bank" role="tab" aria-controls="profile-6-3" aria-selected="false">Bank Account</a>
                      </li>
					  <li class="nav-item">
                        <a class="nav-link" id="tab-4" data-toggle="tab" href="#docs" role="tab" aria-controls="profile-6-4" aria-selected="false">KYC</a>
                      </li>
					  <li class="nav-item">
                        <a class="nav-link" id="tab-5" data-toggle="tab" href="#changePassword" role="tab" aria-controls="profile-6-5" aria-selected="false">Change Password</a>
                      </li>
                    </ul>

					  					
										
										
					<form id="frmprofile" method="post" class="col-md-6" enctype="multipart/form-data">
				     <div class="tab-content tab-content-solid">
                      <div class="tab-pane fade active show" id="personal" role="tabpanel" aria-labelledby="personal">
                        <div class="row">
							<div class="col-md-12">
							<section>
								<h4>Personal Info</h4>
								<div class="row">
									<div class="form-group col-md-6">
									  <label>First Name: *</label>
									  <input type="text" name="firstName" id="firstName" class="form-control" required aria-invalid="true" aria-describedby="firstNameHelp" placeholder="Enter First Name" value="<?php echo $profile->name;?>" readonly>
									  <small id="firstNameHelp" class="form-text text-muted"></small>
									</div>
									<div class="form-group col-md-6">
									  <label>Last Name: *</label>
									  <input type="text" name="lastName" id="lastName" class="form-control" placeholder="Last Name" value="<?php echo $profile->last_name;?>" readonly>
									  <small id="lastNameHelp" class="form-text text-muted"></small>
									</div>
								</div>
								<div class="row">
									<div class="form-group col-md-6">
									  <label>Gender: *</label>
									  <select class="form-control gender" id="selectGender" name="selectGender" disabled>
										  <option value="Male" <?php if($profile->gender=="Male") echo "Selected";?>>Male</option>
										  <option value="Female" <?php if($profile->gender=="Female") echo "Selected";?>>Female</option>
								      </select>
									</div>
									<div class="form-group col-md-6">
									  <label>Date of Birth:*</label>
          							  <input class="form-control" id="dob" name="dob" data-inputmask="'alias': 'date'" value="<?php echo date("d/m/Y", strtotime($profile->dob));?>" readonly>
									</div>
								</div>
								<div class="row">
									<div class="form-group col-md-6">
										  <label>Mobile Number: *</label><br/>
										  <input type="tel" name="mobileNumber" id="mobileNumber" class="form-control col-md-12" placeholder="Mobile Number" maxlength="10" value="+<?php echo  $profile->country_code . $profile->mobile_number;?>" readonly>
									</div>
									<div class="form-group col-md-6">
									  <label>Email Address: *</label>
									  <input type="email" name="emailID" id="emailID" class="form-control" placeholder="Email Address" type="email" value="<?php echo $profile->email_address;?>" readonly>
									</div>
								</div>
							</section>
							 </div>                         
						 </div>
                      </div>


                      <div class="tab-pane fade" id="address" role="tabpanel" aria-labelledby="address">
						<div class="row">
							<div class="col-md-12">

							<section>
								<h4>Address Info</h4>
								<div class="row">
									<div class="form-group col-md-6">
									  <label>Address Line1:</label>
									  <input type="text" name="addressLine1" id="addressLine1" class="form-control" required aria-invalid="true" aria-describedby="addressLine1Help" placeholder="Enter Address Line1" value="<?php echo $profile->address1;?>" readonly>
									  <small id="addressLine1Help" class="form-text text-muted"></small>
									</div>
									<div class="form-group col-md-6">
									  <label>Address Line2:</label>
									  <input type="text" name="addressLine2" id="addressLine2" class="form-control" placeholder="Enter Address Line2" value="<?php echo $profile->address2;?>" readonly>
									  <small id="addressLine2Help" class="form-text text-muted"></small>
									</div>
								</div>
								<div class="row">
									<div class="form-group col-md-6">
									  <label>Zip Code:</label>
									  <input type="text" name="zipCode" id="zipCode" class="form-control" required aria-invalid="true" aria-describedby="zipCodeHelp" placeholder="Enter a Zip Code" value="<?php echo $profile->zip_code;?>" readonly>
									  <small id="zipCodeHelp" class="form-text text-muted"></small>
									</div>
									<div class="form-group col-md-6">
									  <label>Country:</label>
									  <input type="text" name="country" id="country" class="form-control" placeholder="Enter the country name" value="<?php echo $profile->country;?>" readonly>
									  <small id="countryHelp" class="form-text text-muted"></small>
									</div>
								</div>
								<div class="row">
									<div class="form-group col-md-6">
									  <label>State:</label>
									  <input type="text" name="state" id="state" class="form-control" required aria-invalid="true" aria-describedby="stateHelp" placeholder="Enter the state name" value="<?php echo $profile->state;?>" readonly>
									  <small id="stateHelp" class="form-text text-muted"></small>
									</div>
									<div class="form-group col-md-6">
									  <label>City:</label>
									  <input type="text" name="city" id="city" class="form-control" placeholder="Enter the city name" value="<?php echo $profile->city;?>" readonly>
									  <small id="cityHelp" class="form-text text-muted"></small>
									</div>
								</div>
							 </section>
							 </div>                         
						 </div>
                      </div>



                      <div class="tab-pane fade" id="bank" role="tabpanel" aria-labelledby="bank">
                        <div class="row">
							<div class="col-md-12">

							<section>
								<h4>Bank Account Info</h4>
								<div class="row">
									<div class="form-group col-md-6">
									  <label>Account Number:</label>
									  <input type="text" name="accountNo" id="accountNo" class="form-control" required aria-invalid="true" aria-describedby="accountNoHelp" placeholder="Enter Account Number" value="<?php echo $profile->account_number;?>" readonly>
									  <small id="accountNoHelp" class="form-text text-muted"></small>
									</div>
									<div class="form-group col-md-6">
									  <label>Bank Name:</label>
									  <input type="text" name="bankName" id="bankName" class="form-control" placeholder="Enter Bank Name" value="<?php echo $profile->bank_name;?>" readonly>
									  <small id="bankNameHelp" class="form-text text-muted"></small>
									</div>
								</div>
								<div class="row">
									<div class="form-group col-md-6">
									  <label>Swift Code:</label>
									  <input type="text" name="swiftCode" id="swiftCode" class="form-control" aria-invalid="true" aria-describedby="swiftCodeHelp" placeholder="Enter a Swift Code" value="<?php echo $profile->swift_code;?>" readonly>
									  <small id="swiftCodeHelp" class="form-text text-muted"></small>
									</div>
									<div class="form-group col-md-6">
									  <label>IFSC Code:</label>
									  <input type="text" name="ifscCode" id="ifscCode" class="form-control" placeholder="Enter IFSC Code" value="<?php echo $profile->ifsc_code;?>" readonly>
									  <small id="ifscCodeHelp" class="form-text text-muted"></small>
									</div>
								</div>
	
							</section>
							 </div>                         
						 </div>
                      </div>





					  <div class="tab-pane fade" id="docs" role="tabpanel" aria-labelledby="docs">
                        <div class="row">
							<div class="col-md-12">

							<section>
								<h4>KYC Upload</h4>
								<div class="row">
								  <div class="form-group col-md-6">
									<div class="form-radio form-radio-flat">
									  <label class="form-check-label">
										<input type="radio" class="form-check-input" name="membershipRadios" id="membershipRadios1" value="1" <?php if($profile->account_type!=2) echo "checked"; ?>>
										Individual
									  <i class="input-helper"></i></label>
									</div>
								  </div>
								  <div class="form-group col-md-6">
									<div class="form-radio form-radio-flat">
									  <label class="form-check-label">
										<input type="radio" class="form-check-input" name="membershipRadios" id="membershipRadios2" value="2" <?php if($profile->account_type==2) echo "checked";?>>
										Company
									  <i class="input-helper"></i></label>
									</div>
								  </div>
								</div>
								<div class="row">
								   <div class="form-group col-md-5">
									  <label id="lblKYC">Your PAN / AADHAR Card: *</label>
									  <input type="text" name="txtKYC" id="txtKYC" class="form-control" placeholder="PAN / AADHAR Card" readonly value="<?php echo $profile->pan_no;?>">
								   </div>
								   <div class="form-group col-md-6">
									 <input type="file" class="dropify" name="kyc" id="kyc" data-max-file-size="5M" data-allowed-file-extensions="pdf png jpeg jpg" accept="image/png, image/jpg, image/jpeg, application/pdf" data-default-file='<?php if(!empty($profile->doc_name)) echo 'https://s3.ap-south-1.amazonaws.com/mybooster/KYC/' . $profile->doc_name;?>'>
								   </div>
							   </div>	
							</section>
							 </div>                         
						 </div>
                      </div>



					  <div class="tab-pane fade" id="changePassword" role="tabpanel" aria-labelledby="changePassword">
						<div class="row">
							<div class="col-md-12">

							<section>
								<h4>Change Password</h4>
								<div class="row">
									<div class="form-group col-md-6">
									  <label>Old Password:</label>
									  <input type="password" name="oldPassword" id="oldPassword" class="form-control" required aria-invalid="true" aria-describedby="oldPasswordHelp" placeholder="Enter your old password">
									  <small id="oldPasswordHelp" class="form-text text-muted"></small>
									</div>
								</div>
								<div class="row">
									<div class="form-group col-md-6">
									  <label>New Password:</label>
									  <input type="password" name="newPassword" id="newPassword" class="form-control" required aria-invalid="true" aria-describedby="newPasswordHelp" placeholder="Enter your new password">
									  <small id="newPasswordHelp" class="form-text text-muted"></small>
									</div>
								</div>
								<div class="row">
									<div class="form-group col-md-6">
									  <label>Confirm Password:</label>
									  <input type="password" name="confirmPassword" id="confirmPassword" class="form-control" required aria-invalid="true" aria-describedby="confirmPasswordHelp" placeholder="Confirm your new password">
									  <small id="confirmPasswordHelp" class="form-text text-muted"></small>
									</div>
								</div>
							 </section>
							 </div>                         
						 </div>

                      </div>
					  <div class="row">
						<div class="form-group col-md-6">
							<button type="submit" class="btn btn-primary btn-fw" id="btnSubmit">Edit</button>
						    <input type="text" name="section" id="section" class="form-control" hidden/>
						</div>
					  </div>

					  <div class="dot-opacity-loader" id="profileloader">
						  <span></span>
						  <span></span>
						  <span></span>
					  </div>

					</div>
					</form>


                  </div>
                </div>
              </div>
            </div>

		

	</div>




  <script src="../js/formpickers.js"></script>
  <script src="../js/formpickers.js"></script>
  <script src="../js/form-addons.js"></script>
  <script src="../js/x-editable.js"></script>


  <script>

	  $(".cancel").click(function(){

			 location.reload();

	   });

	   $("#tab-1, #tab-2, #tab-3, #tab-4").click(function(){
		   disableField();
		   $("#btnSubmit").text("Edit");

	   });

	  
	   $("#tab-5").click(function(){

		   $("#btnSubmit").text("Submit");

	   });


	  function enableField()
		{
			$('#firstName').removeAttr("readonly");
			$('#lastName').removeAttr("readonly");
			$('#mobileNumber').removeAttr("readonly");
			$('#emailID').removeAttr("readonly");
			$('#selectGender').removeAttr("readonly");
			$('#dob').removeAttr("readonly");
			$('#selectGender').removeAttr("disabled");
			$('#addressLine1').removeAttr("readonly");
			$('#addressLine2').removeAttr("readonly");
			$('#zipCode').removeAttr("readonly");
			$('#country').removeAttr("readonly");
			$('#state').removeAttr("readonly");
			$('#city').removeAttr("readonly");
			$('#accountNo').removeAttr("readonly");
			$('#bankName').removeAttr("readonly");
			$('#swiftCode').removeAttr("readonly");
			$('#ifscCode').removeAttr("readonly");
			$('#txtKYC').removeAttr("readonly");

		}


		function disableField()
		{
			
			$('#firstName').attr("readonly", "readonly");
			$('#lastName').attr("readonly", "readonly");
			$('#mobileNumber').attr("readonly", "readonly");
			$('#emailID').attr("readonly", "readonly");
			$('#selectGender').attr("readonly", "readonly");
			$('#dob').attr("readonly", "readonly");
			$('#selectGender').attr("disabled", "disabled");
			$('#addressLine1').attr("readonly", "readonly");
			$('#addressLine2').attr("readonly", "readonly");
			$('#zipCode').attr("readonly", "readonly");
			$('#country').attr("readonly", "readonly");
			$('#state').attr("readonly", "readonly");
			$('#city').attr("readonly", "readonly");
			$('#accountNo').attr("readonly", "readonly");
			$('#bankName').attr("readonly", "readonly");
			$('#swiftCode').attr("readonly", "readonly");
			$('#ifscCode').attr("readonly", "readonly");
			$('#txtKYC').attr("readonly", "readonly");

		}

	
	  
	  $("#btnSubmit").click(function(){

			if($("#btnSubmit").text() == "Edit")
			{
				$("#btnSubmit").text("Save");
				$("#btnCancel1").removeAttr("hidden");
				enableField();
			    return false;

			}


			else
		    {
				$("#frmprofile").validate({
				  rules: {
					firstName: {
					  required: true,
					  minlength: 3
					},
					lastName: {
					  required: true,
					  minlength: 3
					},
					mobileNumber:{
					required: true,
					digits: true,
					minlength: 6,
					},
					emailID: {
					  required: true,
					  email: true
					},
					dob:{
					  required: true,
					},
					addressLine1: {
					  required: true,
					},
					addressLine2: {
					  required: true,
					},
				    country: {
					  required: true,
					},
					zipCode: {
					  required: true,
					},
					state: {
					  required: true,
					},
					city: {
					  required: true,
					},
					accountNo: {
					  required: true,
					},
					bankName: {
					  required: true,
					},
				    country: {
					  required: true,
					},
					ifscCode: {
					  required: true,
					},
					oldPassword: {
					  required: true,
					},
					newPassword: {
					  required: true,
					},
				    confirmPassword: {
					  required: true,
					  equalTo: '#newPassword'
					},
					txtKYC: {
					  required: true,
					},
					kyc: {
					  required: true,
					}
				  },
				  messages: {
					firstName: {
					  required: "Please enter a First Name",
					  minlength: "First Name must consist of at least 3 characters"
					},
					lastName: {
					  required: "Please enter a username",
					  minlength: "Last Name must consist of at least 3 characters"
					},
					mobileNumber:{
					  required: 'Please provide mobile number.',
					  digits:'Please enter a valid mobile number.',
					  minlength: "Please enter valid mobile number."
					},					
					emailID: "Please enter a valid email address.",
                    dob: "Please enter a date of birth.",
					addressLine1: {
					  required: "Please enter address line 1.",
					},
					addressLine2: {
					  required: "Please enter address line 2.",
					},
					country: {
					  required: "Please enter the country name.",
					},
					zipCode: {
					  required: "Please enter the zip code.",
					},
					state: {
					  required: "Please enter the state name.",
					},
				    city: {
					  required: "Please enter the city name.",
					},
					accountNo: {
					  required: "Please enter Account Number.",
					},
					bankName: {
					  required: "Please enter Bank Name.",
					},
					ifscCode: {
					  required: "Please enter the IFSC Code.",
					},
					oldPassword: {
					  required: "Please enter old password.",
					},
					newPassword: {
					  required: "Please enter new password.",
					},
					confirmPassword: {
					  required: "Please enter confirm password.",
					  equalTo: "New Password and Confirm Password should be same."
					},
					txtKYC: {
					  required: "Please enter KYC Details.",
					},
					kyc: {
						required: "Please upload a file.",
					}						
				  },
				  errorPlacement: function(label, element) {
					label.addClass('mt-2 text-danger');
					label.insertAfter(element);
				  },
				  highlight: function(element, errorClass) {
					$(element).parent().addClass('has-danger')
					$(element).addClass('form-control-danger')
				  }

			   });

			   if($("#frmprofile").valid())
			   {
					$("#frmprofile").submit();
			   }

			   else
				   return false;


			}

	  });




	   $("#frmprofile").on('submit',(function(event){
			
		  event.preventDefault();
          $("#btnSubmit").hide();
	      $("#profileloader").show();

		  var section = 0;

		  if($("div#personal").hasClass('active'))
			 section = 1;

		  else if($("div#address").hasClass('active'))
			 section = 2;

		  else if($("div#bank").hasClass('active'))
			 section = 3;

		  else if($("div#docs").hasClass('active'))
			 section = 4;

		  else
			 section = 5;

		  $("#section").val(section);


		  if(section!=5)
		  {

			  $.ajax({
				type        : 'POST', 
				url         : '../API/API_updateProfile.php', 
				data        : new FormData(this),
				dataType    : 'json', 
				encode      : true,
				cache		: false,
				contentType : false,
				processData : false,
			  })

			  .done(function(data){
				$("#btnSubmit").show();
				$("#profileloader").hide();

				if (data.success) { 
					alert(data.message);
					$("#btnSubmit").text("Edit");
					disableField();
					location.reload();
				}

				else{
					 alert(data.message);
					 location.reload();

				} 

			  }) 

			  .fail(function(data){
				  $("#btnSubmit").show();
				  $("#profileloader").hide();
				  alert(data.message);
				  //location.reload();

			   });


		  }


		  else
		  {

			   $.ajax({
				type        : 'POST', 
				url         : '../API/API_changePassword.php', 
				data        : new FormData(this),
				dataType    : 'json', 
				encode      : true,
				cache		: false,
				contentType : false,
				processData : false,
			  })

			  .done(function(data){
				$("#btnSubmit").show();
				$("#profileloader").hide();
				$("#oldPassword").val("");
				$("#newPassword").val("");
				$("#confirmPassword").val("");

				if (data.success) { 
					alert(data.message);
					location.reload();
				}

				else{
					alert(data.message);
				} 

			  }) 

			  .fail(function(data){
				  $("#btnSubmit").show();
				  $("#profileloader").hide();
				  alert(data.message);
				  location.reload();

			   });

		  }



		

	   }));




 </script>


<?php
	include 'footer.php';
?>