<?php

	include 'header.php';
	include 'navbar.php';

	require_once('includes/API_Config.php');
	$obj = new API_Config;
	$data = array();
	$data['refer_id'] = $_SESSION['refer_id'];
	$data['user_id']  = $_SESSION['user_id'];
	$response         = json_decode($obj->call_API("API_earningDetails.php", $data));
	$earnings	      = $response->data->pv_earnings;
	$transactions     = $response->data->transactions;
	//var_dump($transactions[0]);exit;
?>


	<div class="row">
		<div class="col-md-6 grid-margin">
			<div class="card">
				<div class="card-body">
					<h4 class="card-title mb-0">Total Matching PV</h4>
					<div class="d-flex justify-content-between align-items-center">
						<div class="d-inline-block pt-3">
							<div class="d-flex">
								<h2 class="mb-0">
								<?php 
									if(empty($earnings->treeIncentive)) echo number_format("0", 2);
												
									else
										echo number_format($earnings->treeIncentive, 2);
								?> PV</h2>
								<div class="d-flex align-items-center ml-2">
									<i class="mdi mdi-clock text-muted"></i>
									<small class=" ml-1 mb-0">Updated: 
									<?php 
										if(empty($earnings->updatedDate)) echo "N/A";
													
										else
											echo $earnings->updatedDate;
								    ?>							
									</small>
								</div>
							</div>
							<small class="text-gray"></small>
						</div>
						<div class="d-inline-block">
							<div class="bg-success px-4 py-2 rounded">
								<i class="mdi mdi-buffer text-white icon-lg"></i>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="col-md-6 grid-margin">
			<div class="card">
				<div class="card-body">
					<h4 class="card-title mb-0">Total Direct PV</h4>
					<div class="d-flex justify-content-between align-items-center">
						<div class="d-inline-block pt-3">
							<div class="d-flex">
								<h2 class="mb-0">
								<?php 
									if(empty($earnings->directIncentive)) echo number_format("0", 2);
												
									else
										echo number_format($earnings->directIncentive, 2);
								?> PV
								</h2>
								<div class="d-flex algn-items-center ml-2">
									<i class="mdi mdi-clock text-muted"></i>
									<small class=" ml-1 mb-0">
									<?php 
										/*if(empty($earnings->updatedDate)) echo "N/A";
													
										else
											echo $earnings->updatedDate;*/
								    ?>	
									</small>
								</div>
							</div>
							<small class="text-gray"></small>
						</div>
						<div class="d-inline-block">
							<div class="bg-warning px-4 py-2 rounded">
								<i class="mdi mdi-wallet text-white icon-lg"></i>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>


	<div class="card">
            <div class="card-body">
              <h4 class="card-title">Transaction Log</h4>
              <div class="row">
                <div class="col-12 table-responsive">
                  <table id="order-listing" class="table">
                    <thead>
                      <tr>
                          <th>Sr No.</th>
                          <th>Activity</th>
						  <th>Initial PV</th>
						  <th>Amount PV</th>
						  <th>Balance PV</th>
						  <th>Mode</th>
                          <th>Date</th>
						  <th>Status</th>
                      </tr>
                    </thead>
                    <tbody>
					<?php
					if(!empty($transactions))
					{
						$i = 1;
						foreach($transactions as $row)
						{
							echo "<tr>";
							echo "<td>" .  $i++               . "</td>";
							echo "<td>" .  $row->description  . "</td>";
							echo "<td>" .  number_format($row->initial_pv, 2)  . "</td>";
							echo "<td>" .  number_format($row->pv, 2)          . "</td>";
							echo "<td>" .  number_format($row->final_pv, 2)    . "</td>";
							echo "<td>" .  $row->mode         . "</td>";
							echo "<td>" .  $row->date_entered . "</td>";
							echo "<td>" .  "Done" . "</td>";
    						echo "</tr>";
						}

					}

					else
						echo "No Data Available";
					?>                    
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>

<?php
	include 'footer.php';
?>