<?php

	include 'header.php';
	include 'navbar.php';

	require_once('includes/API_Config.php');
	$obj = new API_Config;
	$data = array();
	$data['refer_id'] = $_SESSION['refer_id'];
	$data['user_id']  = $_SESSION['user_id'];
	$response         = json_decode($obj->call_API("API_earningDetails.php", $data));
	$earnings	      = $response->data->pv_earnings;
	$payoutDetails    = $response->data->payoutDetails;
	//var_dump($earnings);exit;
?>


	<div class="row">
		<div class="col-md-6 grid-margin">
			<div class="card">
				<div class="card-body">
					<h4 class="card-title mb-0">Total Matching</h4>
					<div class="d-flex justify-content-between align-items-center">
						<div class="d-inline-block pt-3">
							<div class="d-flex">
								<h2 class="mb-0">
								<?php 
									if(empty($earnings->treeIncentive)) echo number_format("0", 2);
												
									else
										echo number_format($earnings->treeIncentive, 2);
								?> Rs.</h2>
								<!--div class="d-flex align-items-center ml-2">
									<i class="mdi mdi-clock text-muted"></i>
									<small class=" ml-1 mb-0">Updated: 
									<?php 
										/*if(empty($earnings->updatedDate)) echo "N/A";
													
										else
											echo $earnings->updatedDate;*/
								    ?>							
									</small>
								</div-->
							</div>
							<small class="text-gray"></small>
						</div>
						<div class="d-inline-block">
							<div class="bg-success px-4 py-2 rounded">
								<i class="mdi mdi-buffer text-white icon-lg"></i>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="col-md-6 grid-margin">
			<div class="card">
				<div class="card-body">
					<h4 class="card-title mb-0">Total Direct</h4>
					<div class="d-flex justify-content-between align-items-center">
						<div class="d-inline-block pt-3">
							<div class="d-flex">
								<h2 class="mb-0">
								<?php 
									if(empty($earnings->directIncentive)) echo number_format("0", 2);
												
									else
										echo number_format($earnings->directIncentive, 2);
								?> Rs.
								</h2>
								<!--div class="d-flex algn-items-center ml-2">
									<i class="mdi mdi-clock text-muted"></i>
									<small class=" ml-1 mb-0">
									<?php 
										if(empty($earnings->updatedDate)) echo "N/A";
													
										else
											echo $earnings->updatedDate;
								    ?>	
									</small>
								</div-->
							</div>
							<small class="text-gray"></small>
						</div>
						<div class="d-inline-block">
							<div class="bg-warning px-4 py-2 rounded">
								<i class="mdi mdi-wallet text-white icon-lg"></i>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>


	<div class="card">
            <div class="card-body">
              <h4 class="card-title">Transaction Log</h4>
              <div class="row">
                <div class="col-12 table-responsive">
                  <table id="order-listing" class="table">
                    <thead>
                      <tr>
                          <th>Sr No.</th>
                          <th>Payout Date</th>
						  <th>Tree Incentive</th>
						  <th>Direct Incentive</th>
						  <th>Total Incentive</th>
					  </tr>
                    </thead>
                    <tbody>
					<?php
					if(!empty($payoutDetails))
					{
						$i = 1;
						foreach($payoutDetails  as $row)
						{
							echo "<tr>";
							echo "<td>" .  $i++               . "</td>";
							echo "<td>" .  $row->start_date        . "</td>";
							echo "<td>" .  number_format($row->tree_incentive, 2)  . "</td>";
							echo "<td>" .  number_format($row->direct_incentive, 2)          . "</td>";
							echo "<td>" .  number_format($row->incentive, 2)    . "</td>";
    						echo "</tr>";
						}

					}

					else
						echo "No Data Available";
					?>                    
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>

<?php
	include 'footer.php';
?>