<?php
	include 'header.php';
	include 'navbar.php';

	require_once('includes/API_Config.php');
    
?>


	<div class="col-md-12 grid-margin stretch-card">
		  <div class="card">
			<div class="card-body">
			  <h4 class="card-title">Manage Passwords</h4>
				<div class="col-md-12 pl-md-5 pt-4 pt-md-0">
                      <ul class="nav nav-tabs tab-basic" role="tablist">
                        <li class="nav-item">
                          <a class="nav-link active" id="login-tab" data-toggle="tab" href="#login-password" role="tab" aria-controls="login-password" aria-selected="true">Login</a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="transaction-tab" data-toggle="tab" href="#transaction-password" role="tab" aria-controls="#transaction-password" aria-selected="false">Transaction</a>
                        </li>
					  </ul>
                 
					  
    				<form id="frmChangePassword" method="post" enctype="multipart/form-data">
					  <div class="tab-content tab-content-basic">
                        <div class="tab-pane fade show active" id="login-password" role="tabpanel" aria-labelledby="login-tab">
							<div class="row">
								<div class="form-group col-md-4">
								  <label>Old Password:</label>
								  <input type="password" name="oldPassword" id="oldPassword" class="form-control" required aria-invalid="true" aria-describedby="oldPasswordHelp" placeholder="Enter old password">
								  <small id="oldPasswordHelp" class="form-text text-muted"></small>
								</div>
							</div>
							<div class="row">
								<div class="form-group col-md-4">
								  <label>New Password:</label>
								  <input type="password" name="newPassword" id="newPassword" class="form-control" required aria-invalid="true" aria-describedby="newPasswordHelp" placeholder="Enter new password">
								  <small id="newPasswordHelp" class="form-text text-muted"></small>
								</div>
							</div>
							<div class="row">
								<div class="form-group col-md-4">
								  <label>Confirm Password:</label>
								  <input type="password" name="confirmPassword" id="confirmPassword" class="form-control" required aria-invalid="true" aria-describedby="confirmPasswordHelp" placeholder="Confirm new password">
								  <small id="confirmPasswordHelp" class="form-text text-muted"></small>
								</div>
							</div>
                        </div>


                        <div class="tab-pane fade" id="transaction-password" role="tabpanel" aria-labelledby="transaction-tab">
							<div class="row">
								<div class="form-group col-md-4">
								  <label>Mother's Name:</label>
								  <input type="text" name="txtMotherName" id="txtMotherName" class="form-control" required aria-invalid="true" aria-describedby="txtMotherNameHelp" placeholder="Enter Mother's Name">
								  <small id="txtMotherNameHelp" class="form-text text-muted"></small>
								</div>
     						</div>
							<div class="row">
								<div class="form-group col-md-4">
								  <label>New Password:</label>
								  <input type="password" name="newTransactPwd" id="newTransactPwd" class="form-control" required aria-invalid="true" aria-describedby="newTransactPwdHelp" placeholder="Enter new transaction password">
								  <small id="newPasswordHelp" class="form-text text-muted"></small>
								</div>
							</div>
							<div class="row">
								<div class="form-group col-md-4">
								  <label>Confirm Password:</label>
								  <input type="password" name="confirmTransactPwd" id="confirmTransactPwd" class="form-control" required aria-invalid="true" aria-describedby="confirmTransactPwdHelp" placeholder="Confirm new transaction password">
								  <small id="confirmTransactPwdHelp" class="form-text text-muted"></small>
								</div>
							</div>
                          </div>

						  <br/>

						  <div class="row">
								<div class="form-group col-md-3 dot-opacity-loader" id="profileloader">
							 		<span></span>
									<span></span>
									<span></span>
								</div>
						   </div>               

						   <div class="row">
								<div class="form-group col-md-6">
									<button type="submit" class="btn btn-primary btn-fw" id="btnChangePassword">Submit</button>
									<input type="text" name="section" id="section" class="form-control" hidden/>
									<input type="text" name="txtAuthenticate" id="txtAuthenticate" class="form-control" hidden/>
								</div>
							</div>
	

						</form>

			   </div>
		  </div>
		</div>
	  </div>
	</div>

	<div class="modal fade" id="otpPasswordModal" tabindex="-1" role="dialog" aria-labelledby="PasswordModal" style="display:none;" aria-hidden="true">
	   <div class="modal-dialog" role="document">
		 <div class="modal-content">
			
			<div class="modal-header">
			  <h5 class="modal-title" id="PasswordModal">Enter Your Transaction Password</h5>
			</div>

			<div class="modal-body">
			  <form id="frmOTPPassword" action="" method="POST" enctype="multipart/form-data">
				<div class="row">
					<div class="form-group col-md-12">
					  <input type="password" name="otpTransactionPassword" id="otpTransactionPassword" class="form-control" required aria-invalid="true" aria-describedby="otpTransactionPasswordHelp" placeholder="Enter Your Transaction Password">
					  <small id="otpTransactionPasswordHelp" class="form-text text-muted"></small>
					</div>
				</div>
			   </form>
			</div>

			<div class="modal-footer">
			  <button type="button" class="btn btn-primary" id="btnOTPPassword">Submit</button>
			  <button type="button" class="btn btn-light" id="closeModal" data-dismiss="modal">Close</button>
			</div>

		</div>
	  </div>
   </div>


  <script src="../js/formpickers.js"></script>
  <script src="../js/formpickers.js"></script>
  <script src="../js/form-addons.js"></script>
  <script src="../js/x-editable.js"></script>
  <?php
		include 'footer.php';
   ?>




  <script>
   

   $("#login-tab,  #transaction-tab").click(function(){
		$("#oldPassword").val("");
		$("#newPassword").val("");
		$("#confirmPassword").val("");
		$("#txtAuthenticate").val("");
		$("#otpTransactionPassword").val("");
		$("#txtMotherName").val("");
		$("#newTransactPwd").val("");
		$("#confirmTransactPwd").val("");

   });
	
	$("#btnChangePassword").click(function(){


		$("#frmChangePassword").validate({
			  rules: {
				oldPassword: {
				  required: true,
				  minlength: 6,
				},
				newPassword: {
				  required: true,
				  minlength: 6,
				  notEqualTo: '#oldPassword',
				},
				confirmPassword: {
				  required: true,
				  equalTo: '#newPassword'
				},
				txtMotherName: {
				  required: true,
				  minlength: 3,
				},
				newTransactPwd: {
				  required: true,
				  minlength: 6,
				},
				confirmTransactPwd: {
				  required: true,
				  equalTo: '#newTransactPwd'
				}	
			  },
			  messages: {
				oldPassword: {
				  required: "Please enter old password.",
		    	  minlength: "Password must be of atleast 6 characters.",
				},
				newPassword: {
				  required: "Please enter new password.",
  		    	  minlength: "Password must be of atleast 6 characters.",
				  notEqualTo: "Old and New password cannot be same."
				},
				confirmPassword: {
				  required: "Please enter confirm password.",
				  equalTo: "New Password and Confirm Password should be same.",
				},
				txtMotherName: {
				  required: "Please enter mother's name.",
				  minlength: "Please enter atleast 3 characters"
				},
				newTransactPwd: {
				  required: "Please enter new password.",
		    	  minlength: "Password must be of atleast 6 characters."
				},
				confirmTransactPwd: {
				  required: "Please confirm new password.",
				  equalTo: "New and Confirm Password should be same."
				}
			  },
			  errorPlacement: function(label, element) {
				label.addClass('mt-2 text-danger');
				label.insertAfter(element);
			  },
			  highlight: function(element, errorClass) {
				$(element).parent().addClass('has-danger')
				$(element).addClass('form-control-danger')
			  }

		 });

		 if($("#frmChangePassword").valid())
		 {
			  $('#otpPasswordModal').modal('show');
			  return false;
		 }

		 else
			 return false;


	});



	$("#frmChangePassword").on('submit',(function(event){

		   event.preventDefault();
		   $("#btnChangePassword").hide();
		   $("#profileloader").show();

		   
		  var section = 0;

		  if($("div#login-password").hasClass('active'))
			 section = 1;

		  else if($("div#transaction-password").hasClass('active'))
			 section = 2;


		  $("#section").val(section);

		  $.ajax({
			type        : 'POST', 
			url         : '../API/API_changePassword.php', 
			data        : new FormData(this),
			dataType    : 'json', 
			encode      : true,
			cache		: false,
			contentType : false,
			processData : false,
		  })

		  .done(function(data){
			$("#btnChangePassword").show();
			$("#profileloader").hide();
			$("#oldPassword").val("");
			$("#newPassword").val("");
			$("#confirmPassword").val("");
			$("#txtAuthenticate").val("");
			$("#otpTransactionPassword").val("");
			$("#txtMotherName").val("");
			$("#newTransactPwd").val("");
			$("#confirmTransactPwd").val("");


			if (data.success) { 
				location.reload();
				alert(data.message);
			}

			else{
				alert(data.message);
			} 

		  }) 

		 .fail(function(data){
			  location.reload();
 			  $("#btnChangePassword").show();
			  $("#profileloader").hide();
			  alert(data.message);
		  });

	}));



	$("#btnOTPPassword").click(function(){

			$("#frmOTPPassword").validate({
			  rules: {
				profileTransactionPassword: {
					required: true,
					minlength: 6
				}
			  },
			  messages: {
				profileTransactionPassword:{
					required: 'Please enter your transaction password.',
					minlength: 'Transaction password must be of atleast 6 characters.'
				}
			  },
			  errorPlacement: function(label, element) {
				label.addClass('mt-2 text-danger');
				label.insertAfter(element);
			  },
			  highlight: function(element, errorClass) {
				$(element).parent().addClass('has-danger')
				$(element).addClass('form-control-danger')
			  }

		   });

		   if($("#frmOTPPassword").valid())
		   {
			   $("#txtAuthenticate").val($("#otpTransactionPassword").val());
			   $("#frmOTPPassword").submit();
			   return true;

		   }

		   else
			   return false;

	 });


	 $("#frmOTPPassword").on('submit',(function(event){

		   $('#closeModal').trigger('click');
		   $("#frmChangePassword").submit();

	 }));



</script>

</body>
</html>