<?php
	include 'header.php';
	include 'navbar.php';

	require_once('includes/API_Config.php');
    
	$obj = new API_Config;
	$data = array();
	$data['refer_id'] = $_SESSION['refer_id'];
	$data['user_id'] = $_SESSION['user_id'];
	$response = json_decode($obj->call_API("API_getProfile.php", $data));
	$profile = $response->profile_data[0];
?>
   
	   <div class="col-12 grid-margin">
		  <div class="card">
			<div class="card-body">
			  <h4 class="card-title">Edit Profile</h4>
                  <form class="form-sample" id="frmKYC" method="post"b>
                    <p class="card-description">
                      KYC Uploads
                    </p>
					<div class="row">
					  <div class="form-group col-md-3">
						<div class="form-radio form-radio-flat">
						  <label class="form-check-label">
							<input type="radio" class="form-check-input" name="accountTypeRadios" id="accountTypeRadios1" value="1" 
							<?php if($profile->account_type==1) echo "checked"; else if(empty($profile->account_type)) echo "checked";?> disabled>
							Individual
						  <i class="input-helper"></i></label>
						</div>
					  </div>
					  <div class="form-group col-md-3">
						<div class="form-radio form-radio-flat">
						  <label class="form-check-label">
							<input type="radio" class="form-check-input" name="accountTypeRadios" id="accountTypeRadios2" value="2" 
							<?php if($profile->account_type==2) echo "checked";?> disabled>
							Company
						  <i class="input-helper"></i></label>
						</div>
					  </div>
					</div>
					<div class="row" id="companyRow" <?php if($profile->account_type==1 || empty($profile->account_type)) echo "hidden";?>>
					    <div class="form-group col-md-3">
                          <label>Company Name: *</label>
                          <input type="text" name="companyName" id="companyName" class="form-control" aria-describedby="companyNameHelp" placeholder="Enter Company Name" value="<?php echo $profile->company_name;?>" required disabled>
						  <small id="companyNameHelp" class="form-text text-muted"></small>
                        </div>
						<div class="form-group col-md-3">
                          <label>GST No: *</label>
                          <input type="text" name="txtGSTNo" id="txtGSTNo" class="form-control" aria-describedby="txtGSTNoHelp" placeholder="Enter GST Number" value="<?php echo $profile->gst_no;?>" required disabled>
						  <small id="txtGSTNoHelp" class="form-text text-muted"></small>
                        </div> 
					</div>
					<div class="row">
					   <div class="form-group col-md-3">
						  <label id="lblKYC">PAN / Tax ID Number: *</label>
						  <input type="text" name="txtPan" id="txtPan" class="form-control" placeholder="PAN / Tax ID Number"  value="<?php echo $profile->pan_no;?>" disabled>
					   </div>
					   <div class="form-group col-md-2">
						 <input type="file" class="dropify" name="panDocs" id="panDocs" data-max-file-size="2M" data-allowed-file-extensions="pdf png jpeg jpg" accept="image/png, image/jpg, image/jpeg, application/pdf" data-default-file='<?php if(!empty($profile->doc_name)) echo 'https://s3.ap-south-1.amazonaws.com/mybooster/KYC/' . $profile->doc_name;?>' disabled>
    					 <input type="text" name="txtpanDocs" id="txtpanDocs" class="form-control" value="<?php echo $profile->doc_name;?>" hidden>
					   </div>
				    </div>
					<div class="row">
					   <div class="form-group col-md-3">
						<div class="form-radio form-radio-flat">
						  <label class="form-check-label">
							<input type="radio" class="form-check-input" name="addressProof" id="addressProof1" value="1" 
								<?php if($profile->address_proof==1) echo "checked"; else if(empty($profile->address_proof)) echo "checked";?> disabled>
							AADHAR / Social Security Number
						  <i class="input-helper"></i></label>
						</div>
					   </div>
					   <div class="form-group col-md-2">
						<div class="form-radio form-radio-flat">
						  <label class="form-check-label">
							<input type="radio" class="form-check-input" name="addressProof" id="addressProof2" value="2"
								<?php if($profile->address_proof==2) echo "checked";?> disabled>
							Driving License
						  <i class="input-helper"></i></label>
						</div>
					   </div>
					   <div class="form-group col-md-3">
						<div class="form-radio form-radio-flat">
						  <label class="form-check-label">
							<input type="radio" class="form-check-input" name="addressProof" id="addressProof3" value="3"
								<?php if($profile->address_proof==3) echo "checked";?> disabled>
							Passport
						  <i class="input-helper"></i></label>
						</div>
					   </div>
				    </div>
					<div class="row">
					   <div class="form-group col-md-3">
                          <label></label>
                          <input type="text" name="addressProofInfo" id="addressProofInfo" class="form-control" aria-describedby="" placeholder="Enter Information Here" value="<?php echo $profile->proof_id;?>" required disabled>
						  <small id="addressProofInfoHelp" class="form-text text-muted"></small>
                       </div> 
					   <div class="form-group col-md-2" id="frontRow">
					   	 <label id="lblFront">Front Page: *</label>
						 <input type="file" class="dropify" name="frontDocs" id="frontDocs" data-max-file-size="2M" data-allowed-file-extensions="pdf png jpeg jpg" accept="image/png, image/jpg, image/jpeg, application/pdf" data-default-file='<?php if(!empty($profile->front_cover)) echo 'https://s3.ap-south-1.amazonaws.com/mybooster/KYC/' . $profile->front_cover;?>' disabled>
						 <input type="text" name="txtFrontDocs" id="txtFrontDocs" class="form-control" value="<?php echo $profile->front_cover;?>" hidden>
					   </div>
					   <div class="form-group col-md-2" id="backRow"<?php if($profile->address_proof==2) echo "hidden";?>>
					   	 <label id="lblBack">Back Page: *</label>
						 <input type="file" class="dropify" name="backDocs" id="backDocs" data-max-file-size="2M" data-allowed-file-extensions="pdf png jpeg jpg" accept="image/png, image/jpg, image/jpeg, application/pdf" data-default-file='<?php if(!empty($profile->back_cover)) echo 'https://s3.ap-south-1.amazonaws.com/mybooster/KYC/' . $profile->back_cover;?>' disabled>
						 <input type="text" name="txtBackDocs" id="txtBackDocs" class="form-control" value="<?php echo $profile->back_cover;?>" hidden>
					   </div>
				    </div>
					<div class="row">
						<div class="form-group col-md-6">
						  <button type="btnKYCSubmit" class="btn btn-primary btn-fw" id="btnKYCSubmit">Edit</button>
						  <input type="text" name="txtAuthenticate" id="txtAuthenticate" class="form-control" hidden/>
						</div>
					</div>
					<div class="dot-opacity-loader" id="profileloader">
						  <span></span>
						  <span></span>
						  <span></span>
					</div>
				</form>
			</div>
		  </div>
		</div>


		<div class="modal fade" id="KYCPasswordModal" tabindex="-1" role="dialog" aria-labelledby="KYCPasswordModal" style="display:none;" aria-hidden="true">
		   <div class="modal-dialog" role="document">
			 <div class="modal-content">
				
				<div class="modal-header">
				  <h5 class="modal-title">Enter Your Transaction Password</h5>
				</div>

				<div class="modal-body">
				  <form id="frmKYCPassword" action="" method="POST" enctype="multipart/form-data">
					<div class="row">
						<div class="form-group col-md-12">
						  <input type="password" name="kycTransactionPassword" id="kycTransactionPassword" class="form-control" required aria-invalid="true" aria-describedby="kycTransactionPasswordHelp" placeholder="Enter Your Transaction Password">
						  <small id="kycTransactionPasswordHelp" class="form-text text-muted"></small>
						</div>
					</div>
				   </form>
				</div>

				<div class="modal-footer">
				  <button type="button" class="btn btn-primary" id="btnKYCPassword">Submit</button>
				  <button type="button" class="btn btn-light" id="closeModal" data-dismiss="modal">Close</button>
				</div>

			</div>
		  </div>
	   </div>


<?php
	include 'footer.php';
?>

<script type="text/javascript">

 function enableField()
 {

	$("#accountTypeRadios1").removeAttr('disabled');
	$("#accountTypeRadios2").removeAttr('disabled');
	$("#companyName").removeAttr('disabled');
	$("#txtGSTNo").removeAttr('disabled');
	$("#txtPan").removeAttr('disabled');
	$("#panDocs").removeAttr('disabled');
	$("#addressProof1").removeAttr('disabled');
	$("#addressProof2").removeAttr('disabled');
	$("#addressProof3").removeAttr('disabled');
	$("#addressProofInfo").removeAttr('disabled');
	$("#frontDocs").removeAttr('disabled');
	$("#backDocs").removeAttr('disabled');

 }


 $("input[name=accountTypeRadios]").click(function(){

	if($("input[name=accountTypeRadios]:checked").val() == 1)
	 {
		$("#companyRow").attr("hidden", "hidden");
		$("#companyName").removeAttr('required');
		$("#txtGSTNo").removeAttr('required');

	 }

	else
	 {
		$("#companyRow").removeAttr('hidden');
		$("#companyName").attr('required', 'required');
		$("#txtGSTNo").attr('required', 'required');

	 }

 });


 
 $("input[name=addressProof]").click(function(){

	if($("input[name=addressProof]:checked").val() == 1 || $("input[name=addressProof]:checked").val() == 3)
	 {
		$("#backRow").removeAttr('hidden');
	 }

	else
	 {
		$("#backRow").attr("hidden", "hidden");
	 }

 });




 $("#btnKYCSubmit").click(function(){


	 if($("#btnKYCSubmit").text()=="Edit")
	 {
		 enableField();
		 $("#btnKYCSubmit").text("Save");
		 $("#txtPan").removeAttr('readonly');
		 $("#addressProofInfo").removeAttr('readonly');
		 return false;
	 }

	 else
	 {
		$("#frmKYC").validate({
			  rules: {
				txtPan: {
				  required: true,
                  regex: /^([A-Z]){5}([0-9]){4}([A-Z]){1}?$/,
				},
				addressProofInfo: {
				  required: true,
				  regex: /^([0-9]){12}?$/,
				}
			  },
			  messages: {
				txtPan: {
				  required: "Please enter the pan card info.",
				     regex: "Please enter a valid PAN Number."
				},
				addressProofInfo: {
				  required: "Please enter the address proof info.",
					 regex: "Please enter the valid aadhar number without using space."
				}
			  },
			  errorPlacement: function(label, element) {
				label.addClass('mt-2 text-danger');
				label.insertAfter(element);
			  },
			  highlight: function(element, errorClass) {
				$(element).parent().addClass('has-danger')
				$(element).addClass('form-control-danger')
			  }

		 });

		 if($("#frmKYC").valid())
		 {
			  $('#KYCPasswordModal').modal('show');
			  return false;
			 
		 }

		 else
			 return false;


	 }


 });



	$("#frmKYC").on('submit',(function(event){


   		  $("#btnKYCSubmit").attr("disabled","disabled").css("cursor","wait");


		  event.preventDefault();
		  $("btnKYCSubmit").hide();
		  $("#profileloader").show();

		  $.ajax({
			type        : 'POST', 
			url         : '../API/API_KYCUploads.php', 
			data        : new FormData(this),
			dataType    : 'json', 
			encode      : true,
			cache		: false,
			contentType : false,
			processData : false,
		  })

		  .done(function(data){
		
			if (data.success) { 
				location.reload();
				alert(data.message);
			}

			else{
				location.reload();
				alert(data.message);
			}

			("#btnKYCSubmit").removeAttr("disabled").css("cursor","pointer");


		  }) 

		 .fail(function(data){
			  //location.reload();
 			  $("#btnKYCSubmit").show();
			  $("#profileloader").hide();
			  alert(data.message);
		  });

	}));



	$("#btnKYCPassword").click(function(){

			$("#frmKYCPassword").validate({
			  rules: {
				kycTransactionPassword: {
					required: true,
					minlength: 6
				}
			  },
			  messages: {
				kycTransactionPassword: {
					required: 'Please enter your transaction password.',
					minlength: 'Transaction password must be of atleast 6 characters.'
				}
			  },
			  errorPlacement: function(label, element) {
				label.addClass('mt-2 text-danger');
				label.insertAfter(element);
			  },
			  highlight: function(element, errorClass) {
				$(element).parent().addClass('has-danger')
				$(element).addClass('form-control-danger')
			  }

		   });

		   if($("#frmKYCPassword").valid())
		   {
			   $("#txtAuthenticate").val($("#kycTransactionPassword").val());
			   $("#frmKYCPassword").submit();
			   return true;

		   }

		   else
			   return false;

	 });


	 $("#frmKYCPassword").on('submit',(function(event){

		   $('#closeModal').trigger('click');
		   $("#frmKYC").submit();

	 }));








</script>

  </body>
</html>

