<?php

	include 'Header.php';
    include 'Navbar.php';
	include 'Sidebar.php';
	include 'includes/admin_API_Config.php';

	
	$obj  = new API_Config;
	$data = array();
	$data['admin_username'] = $_SESSION['admin_username'];
	$response = json_decode($obj->call_API("API_Payout_List.php", $data));
	error_reporting(0);
	//var_dump($response->payoutList);

?>




<!-- BEGIN CONTENT -->
	<div class="page-content-wrapper">
		<div class="page-content">
			<!-- BEGIN SAMPLE PORTLET CONFIGURATION MODAL FORM-->
			<!-- BEGIN PAGE HEADER-->
			<!-- BEGIN PAGE BREADCRUMB -->
			<ul class="page-breadcrumb breadcrumb">
				<li>
					<a href="#">Dashboard</a>
					<i class="fa fa-circle"></i>
				</li>
				<li>
					<a href="#">Payout</a>
					<i class="fa fa-circle"></i>
				</li>
				<li>
					<a href="#">Calculate</a>
				</li>
			</ul>
			<!-- END PAGE BREADCRUMB -->
			<!-- END PAGE HEADER-->
			<!-- BEGIN PAGE CONTENT-->

			<!-- BEGIN SAMPLE FORM PORTLET-->
			<div class="portlet box blue">
				<div class="portlet-title">
					<div class="caption">
						<i class="icon-settings"></i>
						<span class="caption-subject bold uppercase">Calculate Payout</span>
					</div>
				</div>
				<div class="portlet-body form">
					<?php 

						$enable    = $response->payoutList[0]->status;
						$startDate = date('d-m-Y 00:00:00', strtotime($response->payoutList[0]->payout_end_date . ' + 1 days')); 
						$endDate   = date('d-m-Y 23:59:59', strtotime(date("Y/m/d") . ' - 16 days'));
					
					?>
				    <form action="#" method="POST" action="#" class="form-inline">
						<div class="form-body"><br/>
							<div class="row">
								<div class="col-md-3 offset-md-2">
									<input class="form-control form-control-inline input-medium date-picker" data-date-format="dd/mm/yyyy" size="16" type="text" value="" placeholder='Select Payout Date' name='payout_date' id='payout_date'>
									<span class="help-block"></span>
								</div>
								<div class="col-md-3">
									<button type="button" class="btn btn-default" id="btnCalculate">Calculate</button>
								</div>
							</div>
						</div>
					</form>
				</div>

				<div class="portlet-body">
					<div class="table-responsive">
						<table class="table table-striped table-bordered" id="payoutDataTable">
							<thead>
								<tr>
									<th>Sr No.</th>
									<th>Payout No</th>
									<th>Start Date</th>
									<th>End Date</th>
									<th>Status</th>
									<th>View Report</th>
								</tr>
							</thead>
							<tbody>
								<?php
									$i=0;
									foreach($response->payoutList as $row)
									{
										echo "<tr>";
										echo "<td>" . ++$i . "</td>";
										echo "<td> Payout " . $row->id . "</td>";
										echo "<td>" . date('d-m-Y H:i:s',strtotime($row->payout_start_date)) . "</td>";
										echo "<td>" . date('d-m-Y H:i:s',strtotime($row->payout_end_date))   . "</td>";
										//echo "<td>" . date('d-m-Y H:i:s',strtotime($row->payout_run_date))   . "</td>";
										echo "<td>";
										if($row->status)
											echo "Done";
										
										else
											echo "<div class=\"moving-square-loader\" id=\"loader2\"><span></span><span></span></div><button type=\"button\" class=\"btn btn-inverse-primary btn-fw\" id=\"btnRelease\" payout_id=\"" . $row->id  . "\">Release Payout</button>";


										echo "</td>";


										echo "<td><a href=\"Download-Payout-Report.php?payout_id=". $row->id . " \" target=\"_blank\"><span class=\"tab\"><i class=\"btn default btn-xs red-stripe\">Download</i></a></td>";

									}
								?>
							</tbody>
						</table>
					</div>



		</div>
	</div>

<?php

	include 'Footer.php';

?>





   <script type="text/javascript">
   
        $(document).ready(function(){
		
  
		   $('#payoutDataTable').DataTable({
                });

        

   
		   $("#btnCalculate").click(function(){
			   
			 $.blockUI({css: { 
						border: 'none', 
						padding: '15px', 
						backgroundColor: '#000', 
						'-webkit-border-radius': '10px', 
						'-moz-border-radius': '10px', 
						opacity: .5, 
						color: '#fff' 
			},  boxed: true, message: 'Please wait'});


		   
			   var data = {'payout_date': $('#payout_date').val()};

				
			   $.ajax({
						type        : 'POST', 
						url         : '../API/API_Incentive_Payout.php', 
						data        : data,
						dataType    : 'json', 
						encode      : true,
						cache		: false,
				})

				
				.done(function(data){

					window.setTimeout(function() {
						$.unblockUI();
					
						if (data.status) { 
							alert(data.message);
							location.reload();
						}

						else{
							alert(data.message);
						}

					}, 2000);


					$("#").removeAttr("disabled").css("cursor","pointer");
				 })

				
				 
				 .fail(function(data){
					  $("#btnCalculate").show();
					  $("#loader1").hide();
					  alert(data.message);
					  //location.reload();
					  $("#").removeAttr("disabled").css("cursor","pointer");
				 });

		   });


		   $("#btnRelease").click(function(){

			   $("#loader2").show();
			   $("#btnRelease").hide();
			   
			   var data = {'payout_id': $("#btnRelease").attr('payout_id')};


			   $.ajax({
						type        : 'POST', 
						url         : '../API/API_Release_Payout.php', 
						data        : data,
						dataType    : 'json', 
						encode      : true,
						cache		: false,
			   })

				
				.done(function(data){

						$("#btnRelease").show();
						$("#loader2").hide();
					
						if (data.success) { 
							alert(data.message);
							location.reload();
						}

						else{
							 alert(data.message);
							 location.reload();

						}

						$("#").removeAttr("disabled").css("cursor","pointer");;
				 })

				 
				 
				 .fail(function(data){
					  $("#btnRelease").show();
					  $("#loader2").hide();
					  alert(data.message);
					  //location.reload();
					  $("#").removeAttr("disabled").css("cursor","pointer");;
				 });


		   });

		});


 </script>





</body>
</html>