<?php
    
    include 'header.php';

?>

<body class="login">
<!-- BEGIN SIDEBAR TOGGLER BUTTON -->
<div class="menu-toggler sidebar-toggler">
</div>
<!-- END SIDEBAR TOGGLER BUTTON -->
<!-- BEGIN LOGO -->
<div class="logo">
	<a href="login.php">
	<img src="img/logo-light.png" alt="logo" class="logo-default">
	</a>
</div>
<!-- END LOGO -->
<!-- BEGIN LOGIN -->
<div class="content">
	<!-- BEGIN LOGIN FORM -->
	<form class="login-form" id="frmLogin" name="frmLogin" action="" method="post">
		<div class="form-title">
			<span class="form-title">Welcome.</span>
			<span class="form-subtitle">Please login.</span>
		</div>
		<div class="alert alert-danger display-hide">
			<button class="close" data-close="alert"></button>
			<span>
			Enter any username and password. </span>
		</div>
		<div class="form-group">
			<!--ie8, ie9 does not support html5 placeholder, so we just show field title for that-->
			<label class="control-label visible-ie8 visible-ie9">Username</label>
			<input class="form-control form-control-solid placeholder-no-fix" type="text" autocomplete="off" placeholder="Username / Email Address" name="userID" id="userID"/>
		</div>
		<div class="form-group">
			<label class="control-label visible-ie8 visible-ie9">Password</label>
			<input class="form-control form-control-solid placeholder-no-fix" type="password" autocomplete="off" placeholder="Password" name="password"/>
		</div>
		<div class="form-actions">
			<button type="button" id="btnLogin" name="btnLogin" class="btn btn-primary btn-block uppercase">Login</button>
		</div>
		
		</div>
	</form>


<?php

	include 'footer.php';

?>


<script type="text/javascript">
	  
	$(document).ready(function() {
 
  $("#btnLogin").click(function(){

		 // validate signup form on keyup and submit
     $("#frmLogin").validate({
		  rules: {
			userID:{
			  required: true,
			  minlength: 6
			},
			password:{
			  required: true,
			  minlength: 6
			}
		  },
		  messages: {
			userID:{
			required: 'Please enter a username.',
    		minlength: "Username is not valid!"
			},
			password:{
			  required: "Please provide a password",
			  minlength: "Your password must be at least 6 characters long"
			}
		  },
		  errorPlacement: function(label, element) {
			label.addClass('mt-2 text-danger');
			label.insertAfter(element);
		  },
		  highlight: function(element, errorClass) {
			$(element).parent().addClass('has-danger')
			$(element).addClass('form-control-danger')
		  }

		
	  });

	  if($("#frmLogin").valid())
		$("#frmLogin").submit();

  });


	  $("#frmLogin").on('submit',(function(e){

		 e.preventDefault();
		 $("#loader").show();
		 $("#btnLogin").hide();

		 $.ajax({
			type        : 'POST', 
			url         : 'verifyLogin.php', 
			data        : new FormData(this),
			dataType    : 'json', 
			encode      :  true,
			cache		: false,
			contentType : false,
			processData : false,
			})

			.done(function(data){
			  $("#loader").hide();
			  $("#btnLogin").show();

			  if (data.success){
				//alert(data.message);
			    //location.href = 'panel/admin-dashboard.php';
				location.href = 'panel/Dashboard.php';

			  }

			  else{
				alert(data.message);
			  } 

			}) 
			

			.fail(function(data){
				$("#loader").hide();
			    $("#btnLogin").show();
				alert("Some error has occured. Please try again later!"); 
			});

			

		}));

	});




</script>



</body>
</html>