<?php

	include 'header.php';
	include 'navbar.php';
	include 'includes/admin_API_Config.php';

	$obj = new API_Config;
	$data = array();
	$data['refer_id']     = $_REQUEST['refer_id'];
	$data['user_id']      = $_REQUEST['id'];
	$data['customer_id']  = $_REQUEST['customer_id'];
	$response = json_decode($obj->call_API("API_getProfile.php", $data));

	//var_dump($response);
	$profile = $response->profile_data[0];

	error_reporting(0);
   
?>


<div class="col-md-12 grid-margin stretch-card">
		  <div class="card">
			<div class="card-body">
			  <h4 class="card-title">Profile</h4>
				<div class="col-md-12 pl-md-5 pt-4 pt-md-0">
                      <ul class="nav nav-tabs tab-basic" role="tablist">
                        <li class="nav-item">
                          <a class="nav-link active" id="personal-tab" data-toggle="tab" href="#personal" role="tab" aria-controls="personal" aria-selected="true">Personal</a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="address-tab" data-toggle="tab" href="#address" role="tab" aria-controls="address" aria-selected="false">Address</a>
                        </li>
						<li class="nav-item">
                          <a class="nav-link" id="bank-tab" data-toggle="tab" href="#bank" role="tab" aria-controls="bank" aria-selected="false">Bank</a>
                        </li>
						<li class="nav-item">
                          <a class="nav-link" id="login-tab" data-toggle="tab" href="#login-password" role="tab" aria-controls="login-password" aria-selected="true">Login Password</a>
                        </li>
						<li class="nav-item">
                          <a class="nav-link" id="kyc-tab" data-toggle="tab" href="#kyc" role="tab" aria-controls="kyc" aria-selected="true">KYC</a>
                        </li>
                     

                      </ul>
                 
					  
    				<form id="frmEditProfile" method="post" enctype="multipart/form-data">
					  <div class="tab-content tab-content-basic">
                        <div class="tab-pane fade show active" id="personal" role="tabpanel" aria-labelledby="personal-tab">
							<div class="row">
								<div class="form-group col-md-3">
								  <label>First Name: *</label>
								  <input type="text" name="firstName" id="firstName" class="form-control" required aria-invalid="true" aria-describedby="firstNameHelp" placeholder="Enter First Name" value="<?php echo $profile->name;?>" readonly>
								  <small id="firstNameHelp" class="form-text text-muted"></small>
								</div>
								<div class="form-group col-md-3">
								  <label>Last Name: *</label>
								  <input type="text" name="lastName" id="lastName" class="form-control" placeholder="Last Name" value="<?php echo $profile->last_name;?>" readonly>
								  <small id="lastNameHelp" class="form-text text-muted"></small>
								</div>
							</div>
							<div class="row">
								<div class="form-group col-md-3">
								  <label>Gender: *</label>
								  <select class="form-control gender" id="selectGender" name="selectGender" disabled>
									  <option value="Male" <?php if($profile->gender=="Male") echo "Selected";?>>Male</option>
									  <option value="Female" <?php if($profile->gender=="Female") echo "Selected";?>>Female</option>
								  </select>
								</div>
								<div class="form-group col-md-3">
								  <label>Date of Birth:*</label>
								  <input class="form-control" id="dob" name="dob" data-inputmask="'alias': 'date'" value="<?php echo date("d/m/Y", strtotime($profile->dob));?>" readonly>
								</div>
							</div>
							<div class="row">
								<div class="form-group col-md-3">
									  <label>Mobile Number: *</label><br/>
									  <input type="tel" name="mobileNumber" id="mobileNumber" class="form-control col-md-12" placeholder="Mobile Number" maxlength="10" value="+<?php echo  $profile->country_code . $profile->mobile_number;?>" readonly>
								</div>
								<div class="form-group col-md-3">
								  <label>Email Address: *</label>
								  <input type="email" name="emailID" id="emailID" class="form-control" placeholder="Email Address" type="email" value="<?php echo $profile->email_address;?>" readonly>
								</div>
							</div>

                        </div>


                        <div class="tab-pane fade" id="address" role="tabpanel" aria-labelledby="address-tab">
                            <div class="row">
								<div class="form-group col-md-4">
								  <label>Address Line1:</label>
								  <input type="text" name="addressLine1" id="addressLine1" class="form-control" required aria-invalid="true" aria-describedby="addressLine1Help" placeholder="Enter Address Line1" value="<?php echo $profile->address1;?>" readonly>
								  <small id="addressLine1Help" class="form-text text-muted"></small>
								</div>
								<div class="form-group col-md-4">
								  <label>Address Line2:</label>
								  <input type="text" name="addressLine2" id="addressLine2" class="form-control" placeholder="Enter Address Line2" value="<?php echo $profile->address2;?>" readonly>
								  <small id="addressLine2Help" class="form-text text-muted"></small>
								</div>
							</div>
							<div class="row">
								<div class="form-group col-md-4">
								  <label>Zip Code:</label>
								  <input type="text" name="zipCode" id="zipCode" class="form-control" required aria-invalid="true" aria-describedby="zipCodeHelp" placeholder="Enter a Zip Code" value="<?php echo $profile->zip_code;?>" readonly>
								  <small id="zipCodeHelp" class="form-text text-muted"></small>
								</div>
								<div class="form-group col-md-4">
								  <label>Country:</label>
								  <input type="text" name="country" id="country" class="form-control" placeholder="Enter the country name" value="<?php if(empty($profile->country)) echo "India"; else echo $profile->country;?>" readonly>
								  <small id="countryHelp" class="form-text text-muted"></small>
								</div>
							</div>
							<div class="row">
								<div class="form-group col-md-4">
								  <label>State:</label>
								  <input type="text" name="state" id="state" class="form-control" required aria-invalid="true" aria-describedby="stateHelp" placeholder="Enter the state name" value="<?php echo $profile->state;?>" readonly>
								  <small id="stateHelp" class="form-text text-muted"></small>
								</div>
								<div class="form-group col-md-4">
								  <label>City:</label>
								  <input type="text" name="city" id="city" class="form-control" placeholder="Enter the city name" value="<?php echo $profile->city;?>" readonly>
								  <small id="cityHelp" class="form-text text-muted"></small>
								</div>
							</div>
				        </div>



						<div class="tab-pane fade" id="bank" role="tabpanel" aria-labelledby="bank-tab">
                             <div class="row">
								<div class="form-group col-md-3">
								  <label>Account Number:</label>
								  <input type="text" name="accountNo" id="accountNo" class="form-control" required aria-invalid="true" aria-describedby="accountNoHelp" placeholder="Enter Account Number" value="<?php echo $profile->account_number;?>" readonly>
								  <small id="accountNoHelp" class="form-text text-muted"></small>
								</div>
								<div class="form-group col-md-3">
								  <label>Bank Name:</label>
								  <input type="text" name="bankName" id="bankName" class="form-control" placeholder="Enter Bank Name" value="<?php echo $profile->bank_name;?>" readonly>
								  <small id="bankNameHelp" class="form-text text-muted"></small>
								</div>
							</div>
							<div class="row">
								<div class="form-group col-md-3">
								  <label>Swift Code: (optional)</label>
								  <input type="text" name="swiftCode" id="swiftCode" class="form-control" aria-invalid="true" aria-describedby="swiftCodeHelp" placeholder="Enter a Swift Code" value="<?php echo $profile->swift_code;?>" readonly>
								  <small id="swiftCodeHelp" class="form-text text-muted"></small>
								</div>
								<div class="form-group col-md-3">
								  <label>IFSC Code:</label>
								  <input type="text" name="ifscCode" id="ifscCode" class="form-control" placeholder="Enter IFSC Code" value="<?php echo $profile->ifsc_code;?>" readonly>
								  <small id="ifscCodeHelp" class="form-text text-muted"></small>
								</div>
							</div>
				        </div>


						<div class="tab-pane fade" id="login-password" role="tabpanel" aria-labelledby="login-tab">
							<div class="row">
								<div class="form-group col-md-4">
								  <label>New Password:</label>
								  <input type="password" name="newPassword" id="newPassword" class="form-control" required aria-invalid="true" aria-describedby="newPasswordHelp" placeholder="Enter new password">
								  <small id="newPasswordHelp" class="form-text text-muted"></small>
								</div>
							</div>
							<div class="row">
								<div class="form-group col-md-4">
								  <label>Confirm Password:</label>
								  <input type="password" name="confirmPassword" id="confirmPassword" class="form-control" required aria-invalid="true" aria-describedby="confirmPasswordHelp" placeholder="Enter confirm password">
								  <small id="confirmPasswordHelp" class="form-text text-muted"></small>
								</div>
							</div>
							
				        </div>


						<div class="tab-pane fade" id="kyc" role="tabpanel" aria-labelledby="kyc-tab">
							<p class="card-description">
							  KYC Uploads
							</p>
							<div class="row">
							  <div class="form-group col-md-3">
								<div class="form-radio form-radio-flat">
								  <label class="form-check-label">
									<input type="radio" class="form-check-input" name="accountTypeRadios" id="accountTypeRadios1" value="1" 
									<?php if($profile->account_type==1) echo "checked"; else if(empty($profile->account_type)) echo "checked";?> disabled>
									Individual
								  <i class="input-helper"></i></label>
								</div>
							  </div>
							  <div class="form-group col-md-3">
								<div class="form-radio form-radio-flat">
								  <label class="form-check-label">
									<input type="radio" class="form-check-input" name="accountTypeRadios" id="accountTypeRadios2" value="2" 
									<?php if($profile->account_type==2) echo "checked";?> disabled>
									Company
								  <i class="input-helper"></i></label>
								</div>
							  </div>
							</div>
							<div class="row" id="companyRow" <?php if($profile->account_type==1 || empty($profile->account_type)) echo "hidden";?>>
								<div class="form-group col-md-3">
								  <label>Company Name: *</label>
								  <input type="text" name="companyName" id="companyName" class="form-control" aria-describedby="companyNameHelp" placeholder="Enter Company Name" value="<?php echo $profile->company_name;?>" required disabled>
								  <small id="companyNameHelp" class="form-text text-muted"></small>
								</div>
								<div class="form-group col-md-3">
								  <label>GST No: *</label>
								  <input type="text" name="txtGSTNo" id="txtGSTNo" class="form-control" aria-describedby="txtGSTNoHelp" placeholder="Enter GST Number" value="<?php echo $profile->gst_no;?>" required disabled>
								  <small id="txtGSTNoHelp" class="form-text text-muted"></small>
								</div> 
							</div>
							<div class="row">
							   <div class="form-group col-md-3">
								  <label id="lblKYC">PAN / Tax ID Number: *</label>
								  <input type="text" name="txtPan" id="txtPan" class="form-control" placeholder="PAN / Tax ID Number"  value="<?php echo $profile->pan_no;?>" disabled>
							   </div>
							   <div class="form-group col-md-2">
								 <input type="file" class="dropify" name="panDocs" id="panDocs" data-max-file-size="2M" data-allowed-file-extensions="pdf png jpeg jpg" accept="image/png, image/jpg, image/jpeg, application/pdf" data-default-file='<?php if(!empty($profile->doc_name)) echo 'https://s3.ap-south-1.amazonaws.com/mybooster/KYC/' . $profile->doc_name;?>' disabled>
								 <input type="text" name="txtpanDocs" id="txtpanDocs" class="form-control" value="<?php echo $profile->doc_name;?>" hidden>
							   </div>
							</div>
							<div class="row">
							   <div class="form-group col-md-3">
								<div class="form-radio form-radio-flat">
								  <label class="form-check-label">
									<input type="radio" class="form-check-input" name="addressProof" id="addressProof1" value="1" 
										<?php if($profile->address_proof==1) echo "checked"; else if(empty($profile->address_proof)) echo "checked";?> disabled>
									AADHAR / Social Security Number
								  <i class="input-helper"></i></label>
								</div>
							   </div>
							   <div class="form-group col-md-2">
								<div class="form-radio form-radio-flat">
								  <label class="form-check-label">
									<input type="radio" class="form-check-input" name="addressProof" id="addressProof2" value="2"
										<?php if($profile->address_proof==2) echo "checked";?> disabled>
									Driving License
								  <i class="input-helper"></i></label>
								</div>
							   </div>
							   <div class="form-group col-md-3">
								<div class="form-radio form-radio-flat">
								  <label class="form-check-label">
									<input type="radio" class="form-check-input" name="addressProof" id="addressProof3" value="3"
										<?php if($profile->address_proof==3) echo "checked";?> disabled>
									Passport
								  <i class="input-helper"></i></label>
								</div>
							   </div>
							</div>
							<div class="row">
							   <div class="form-group col-md-3">
								  <label></label>
								  <input type="text" name="addressProofInfo" id="addressProofInfo" class="form-control" aria-describedby="" placeholder="Enter Information Here" value="<?php echo $profile->proof_id;?>" required disabled>
								  <small id="addressProofInfoHelp" class="form-text text-muted"></small>
							   </div> 
							   <div class="form-group col-md-2" id="frontRow">
								 <label id="lblFront">Front Page: *</label>
								 <input type="file" class="dropify" name="frontDocs" id="frontDocs" data-max-file-size="2M" data-allowed-file-extensions="pdf png jpeg jpg" accept="image/png, image/jpg, image/jpeg, application/pdf" data-default-file='<?php if(!empty($profile->front_cover)) echo 'https://s3.ap-south-1.amazonaws.com/mybooster/KYC/' . $profile->front_cover;?>' disabled>
								 <input type="text" name="txtFrontDocs" id="txtFrontDocs" class="form-control" value="<?php echo $profile->front_cover;?>" hidden>
							   </div>
							   <div class="form-group col-md-2" id="backRow"<?php if($profile->address_proof==2) echo "hidden";?>>
								 <label id="lblBack">Back Page: *</label>
								 <input type="file" class="dropify" name="backDocs" id="backDocs" data-max-file-size="2M" data-allowed-file-extensions="pdf png jpeg jpg" accept="image/png, image/jpg, image/jpeg, application/pdf" data-default-file='<?php if(!empty($profile->back_cover)) echo 'https://s3.ap-south-1.amazonaws.com/mybooster/KYC/' . $profile->back_cover;?>' disabled>
								 <input type="text" name="txtBackDocs" id="txtBackDocs" class="form-control" value="<?php echo $profile->back_cover;?>" hidden>
							   </div>
							</div>
											
				        </div>

						<br/>
						<input type="text" name="refer_id" id="refer_id" class="form-control" value="<?php echo $_REQUEST['refer_id'];?>" hidden>
						<input type="text" name="user_id" id="user_id" class="form-control" value="<?php echo $_REQUEST['id'];?>" hidden>
						<input type="text" name="customer_id" id="customer_id" class="form-control" value="<?php echo $_REQUEST['customer_id'];?>" hidden>

						<div class="row">
						    <div class="form-group col-md-3 dot-opacity-loader" id="profileloader">
								<span></span>
								<span></span>
								<span></span>
							</div>
						</div>               

						<div class="row">
							<div class="form-group col-md-6">
								<button type="submit" class="btn btn-primary btn-fw" id="btnEditProfile">Edit</button>
								<input type="text" name="section" id="section" class="form-control" hidden/>
								<input type="text" name="txtAuthenticate" id="txtAuthenticate" class="form-control" hidden/>
							</div>
					    </div>
	

						</form>

			   </div>
		  </div>
		</div>
	  </div>
	</div>



  <script src="../js/formpickers.js"></script>
  <script src="../js/formpickers.js"></script>
  <script src="../js/form-addons.js"></script>
  <script src="../js/x-editable.js"></script>
  <?php
		include 'footer.php';
   ?>




<script>

$("#mobileNumber").intlTelInput({
			 preferredCountries: [ "in" ],
			 placeholderNumberType: "MOBILE",
			 separateDialCode: true,

		});


	   $(".cancel").click(function(){

			 location.reload();

	   });

	   $("#personal-tab, #address-tab, #bank-tab, #kyc-tab").click(function(){
		   disableField();
		   $("#btnEditProfile").text("Edit");
	   });


	   $("#login-tab").click(function(){
		   $("#btnEditProfile").text("Save");
	   });


	   $("input[name=accountTypeRadios]").click(function(){

			if($("input[name=accountTypeRadios]:checked").val() == 1)
			 {
				$("#companyRow").attr("hidden", "hidden");
				$("#companyName").removeAttr('required');
				$("#txtGSTNo").removeAttr('required');

			 }

			else
			 {
				$("#companyRow").removeAttr('hidden');
				$("#companyName").attr('required', 'required');
				$("#txtGSTNo").attr('required', 'required');

			 }

	  });


 
	 $("input[name=addressProof]").click(function(){

		if($("input[name=addressProof]:checked").val() == 1 || $("input[name=addressProof]:checked").val() == 3)
		 {
			$("#backRow").removeAttr('hidden');
		 }

		else
		 {
			$("#backRow").attr("hidden", "hidden");
		 }

	 });



	    function enableField()
		{
			$('#firstName').removeAttr("readonly");
		    $('#lastName').removeAttr("readonly");
			$('#mobileNumber').removeAttr("readonly");
			$('#emailID').removeAttr("readonly");
			$('#dob').removeAttr("readonly");
			$('#selectGender').removeAttr("disabled");
			$('#addressLine1').removeAttr("readonly");
			$('#addressLine2').removeAttr("readonly");
			$('#zipCode').removeAttr("readonly");
			$('#country').removeAttr("readonly");
			$('#state').removeAttr("readonly");
			$('#city').removeAttr("readonly");
			$('#accountNo').removeAttr("readonly");
			$('#bankName').removeAttr("readonly");
			$('#swiftCode').removeAttr("readonly");
			$('#ifscCode').removeAttr("readonly");
			$("#accountTypeRadios1").removeAttr('disabled');
			$("#accountTypeRadios2").removeAttr('disabled');
			$("#companyName").removeAttr('disabled');
			$("#txtGSTNo").removeAttr('disabled');
			$("#txtPan").removeAttr('disabled');
			$("#panDocs").removeAttr('disabled');
			$("#addressProof1").removeAttr('disabled');
			$("#addressProof2").removeAttr('disabled');
			$("#addressProof3").removeAttr('disabled');
			$("#addressProofInfo").removeAttr('disabled');
			$("#frontDocs").removeAttr('disabled');
			$("#backDocs").removeAttr('disabled');
	    }


		function disableField()
		{
			
			$('#firstName').attr("readonly", "readonly");
			$('#lastName').attr("readonly", "readonly");
			$('#mobileNumber').attr("readonly", "readonly");
			$('#emailID').attr("readonly", "readonly");
			$('#selectGender').attr("readonly", "readonly");
			$('#dob').attr("readonly", "readonly");
			$('#selectGender').attr("disabled", "disabled");
			$('#addressLine1').attr("readonly", "readonly");
			$('#addressLine2').attr("readonly", "readonly");
			$('#zipCode').attr("readonly", "readonly");
			$('#country').attr("readonly", "readonly");
			$('#state').attr("readonly", "readonly");
			$('#city').attr("readonly", "readonly");
			$('#accountNo').attr("readonly", "readonly");
			$('#bankName').attr("readonly", "readonly");
			$('#swiftCode').attr("readonly", "readonly");
			$('#ifscCode').attr("readonly", "readonly");
			$('#accountTypeRadios1').attr("disabled", "disabled");
			$('#accountTypeRadios2').attr("disabled", "disabled");
			$('#companyName').attr("disabled", "disabled");
			$('#txtGSTNo').attr("disabled", "disabled");
			$('#txtPan').attr("disabled", "disabled");
			$('#panDocs').attr("disabled", "disabled");
			$('#addressProof1').attr("disabled", "disabled");
			$('#addressProof2').attr("disabled", "disabled");
			$('#addressProof3').attr("disabled", "disabled");
			$('#addressProofInfo').attr("disabled", "disabled");
			$('#frontDocs').attr("disabled", "disabled");
			$('#backDocs').attr("disabled", "disabled");


		}



		 $("#btnEditProfile").click(function(){


			if($("#btnEditProfile").text() == "Edit")
			{
				$("#btnEditProfile").text("Save");
				$("#btnCancel").removeAttr("hidden");
				enableField();
			    return false;

			}


			else
		    {
				$("#frmEditProfile").validate({
				  rules: {
					firstName: {
					  required: true,
					  minlength: 3
					},
					lastName: {
					  required: true,
					  minlength: 3
					},
					mobileNumber:{
					required: true,
					digits: true,
					minlength: 6,
					},
					emailID: {
					  required: true,
					  email: true
					},
					dob:{
					  required: true,
					},
					addressLine1: {
					  required: true,
					},
					addressLine2: {
					  required: true,
					},
				    country: {
					  required: true,
					},
					zipCode: {
					  required: true,
					},
					state: {
					  required: true,
					},
					city: {
					  required: true,
					},
					newPassword: {
					  required: true,
					  minlength: 6,
					},
					confirmPassword: {
					  required: true,
					  minlength: 6,
					},
					txtPan: {
					  required: true,
					  regex: /^([A-Z]){5}([0-9]){4}([A-Z]){1}?$/,
					},
					addressProofInfo: {
					  required: true,
					  regex: /^([0-9]){12}?$/,
					}
					
				  },
				  messages: {
					firstName: {
					  required: "Please enter a First Name",
					  minlength: "First Name must consist of at least 3 characters"
					},
					lastName: {
					  required: "Please enter a username",
					  minlength: "Last Name must consist of at least 3 characters"
					},
					mobileNumber:{
					  required: 'Please provide mobile number.',
					  digits:'Please enter a valid mobile number.',
					  minlength: "Please enter valid mobile number."
					},					
					emailID: "Please enter a valid email address.",
                    dob: "Please enter a date of birth.",
					addressLine1: {
					  required: "Please enter address line 1.",
					},
					addressLine2: {
					  required: "Please enter address line 2.",
					},
					country: {
					  required: "Please enter the country name.",
					},
					zipCode: {
					  required: "Please enter the zip code.",
					},
					state: {
					  required: "Please enter the state name.",
					},
				    city: {
					  required: "Please enter the city name.",
					},
				    newPassword: {
					  required: "Please enter new password.",
  					  minlength: "Password must consist of at least 6 characters"

					},
					confirmPassword: {
					  required: "Please enter the confirm password",
					},
					txtPan: {
					  required: "Please enter the pan card info.",
						 regex: "Please enter a valid PAN Number."
					},
					addressProofInfo: {
					  required: "Please enter the address proof info.",
						 regex: "Please enter the valid aadhar number without using space."
					}
				  },
				  errorPlacement: function(label, element) {
					label.addClass('mt-2 text-danger');
					label.insertAfter(element);
				  },
				  highlight: function(element, errorClass) {
					$(element).parent().addClass('has-danger')
					$(element).addClass('form-control-danger')
				  }

			   });

			   if($("#frmEditProfile").valid())
			   {
				   $("#frmEditProfile").submit();
				   return false;

			   }

			   else
				   return false;


			}

	  });



	  $("#frmEditProfile").on('submit',(function(event){


   		  $("#btnEditProfile").attr("disabled","disabled").css("cursor","wait");
		
		  event.preventDefault();
          $("#btnEditProfile").hide();
	      $("#profileloader").show();

		  var section = 0;

		  if($("div#personal").hasClass('active'))
			 section = 1;

		  else if($("div#address").hasClass('active'))
			 section = 2;

		  else if($("div#bank").hasClass('active'))
			 section = 3;

		  else if($("div#login-password").hasClass('active'))
			 section = 4;

		  else if($("div#kyc").hasClass('active'))
			 section = 5;


		  $("#section").val(section);

		  var apiURL='';
		 
		  if(section ===1 || section===2 || section ===3)
			  apiURL = '../API/API_updateProfile.php';

		  else if(section===4)
			  apiURL = '../API/API_changePassword.php';
		
		  else
			  apiURL = '../API/API_KYCUploads.php';


		   	  $.ajax({
				type        : 'POST', 
				url         : apiURL, 
				data        : new FormData(this),
				dataType    : 'json', 
				encode      : true,
				cache		: false,
				contentType : false,
				processData : false,
			  })

			  .done(function(data){
				$("#btnSubmit").show();
				$("#profileloader").hide();

				if (data.success) { 
					alert(data.message);
					$("#btnSubmit").text("Edit");
					disableField();
					location.reload();
				}

				else{
					 alert(data.message);
					 location.reload();

				}

				$("#btnEditProfile").removeAttr("disabled").css("cursor","pointer");;
			  })

			  .fail(function(data){
				  $("#btnSubmit").show();
				  $("#profileloader").hide();
				  alert(data.message);
				  location.reload();
      			  $("#btnEditProfile").removeAttr("disabled").css("cursor","pointer");;
			   });


	 }));


</script>

</body>
</html>