<?php


	require_once("../API/database.php");


	if(!empty($_REQUEST['payout_id']))
	{

		$payoutData = getPayoutRunDetails($_REQUEST['payout_id']);

		if(empty($payoutData['id']))
			echo "Invalid Payout Report Request.";

		else
		{
			$data = getPayoutDetails($_REQUEST['payout_id']);

			if(empty($data[0]['MemberName']))
				echo "No member qualified for a payout";

			else
			{
				/*$flag = false;
				  foreach($data as $row) {
					if(!$flag) {
					  // display field/column names as first row
					  echo implode("\t", array_keys($row)) . "\r\n";
					  $flag = true;
					}
					echo implode("\t", array_values($row)) . "\r\n";
				  }*/
				
		        $date = strtotime($payoutData['payout_start_date']);
				outputCSV($data, "Member Payout " . date('d-m-Y', $date) . ".xls");

			}


		}

	}

	else
		echo "Invalid Payout Report Request";



    function outputCSV($data, $fileName) {
       header('Content-Type:  application/vnd.ms-excel; charset=utf-8');
       # output headers so that the file is downloaded rather than displayed
        header("Content-Disposition: attachment; filename=$fileName");
        # Disable caching - HTTP 1.1
        header("Cache-Control: no-cache, no-store, must-revalidate");
        # Disable caching - HTTP 1.0
        header("Pragma: no-cache");
        # Disable caching - Proxies
        header("Expires: 0");
    
        # Start the ouput
        $output = fopen("php://output", "w");
		$flag = false;
        
         # Then loop through the rows
        foreach ($data as $row) {
			if(!$flag) {
					  // display field/column names as first row
					  echo implode("\t", array_keys($row)) . "\n";
					  $flag = true;
					}
			echo implode("\t", array_values($row)) . "\r\n";
            # Add the rows to the body
            //fputcsv($output, $row); // here you can change delimiter/enclosure
        }
        # Close the stream off
        fclose($output);
    }


	function getPayoutRunDetails($payout_id)
	{
		$dbconnect = new Database();
		$conn = $dbconnect->getConnection();

		 try{
				$stmt  = $conn->prepare("SELECT * from my_payout_run where id=$payout_id");
				$stmt->execute();
				$result = $stmt->fetch(PDO::FETCH_ASSOC);
			 	return $result;
			
			  }catch(Exception $err){
				return 0;
		   } 

	}

	


	function getPayoutDetails($payout_id)
	{
		$dbconnect = new Database();
		$conn = $dbconnect->getConnection();

		 try{
				$stmt  = $conn->prepare("SELECT concat(b.name,' ',b.last_name) as MemberName, a.refer_id as MemberID , a.tree_incentive as TreeIncentive, a.direct_incentive as DirectIncentive, a.incentive as Incentive, b.bank_name as BankName, b.account_number as AccountNumber, b.ifsc_code as IFSCCode, b.pan_no as PanNo, concat('https://s3.ap-south-1.amazonaws.com/mybooster/KYC/', '' ,b.doc_name) as KYC from my_payout_main as a left join my_registration as b on a.refer_id=b.refer_id  WHERE incentive > 0 && payout_id=$payout_id");
				$stmt->execute();
				$result = $stmt->fetchAll(PDO::FETCH_ASSOC);
			 	return $result;
			
			  }catch(Exception $err){
				return 0;
		   } 

	}


?>
