<?php

	include 'header.php';
	include 'navbar.php';
	
 
?>

	 <div class="card">
		<div class="card-body">
		  <h4 class="card-title">Direct Payout Calculation</h4>
		   <form id="frmDirectPayout" method="post"> 

			  <div class="row">
				 <div class="col-md-4">
					 <label>START DATE:</label>
					 <input class="form-control" name="startDate" id="startDate" data-inputmask="'alias': 'datetime'" value="12/10/2018 00:00">
				 </div>
				 <div class="col-md-4">
					 <label>END DATE:</label>
					 <input class="form-control" name="endDate" id="endDate"  data-inputmask="'alias': 'datetime'" value="12/10/2018 23:59">
				 </div>
				 <div class="col-md-4">
					<p>&nbsp;</p>
					<button type="button" class="btn btn-primary" name="btnCalculate" id="btnCalculate">Calculate</button>
				 </div>
			  </div>
			  <div class="dot-opacity-loader" id="loader">
				  <span></span>
				  <span></span>
				  <span></span>
              </div>

		  </form>
		</div>
	  </div>





<?php
	include 'footer.php';
?>



   <script type="text/javascript">
	  
	 $("#btnCalculate").click(function(){

			 // validate signup form on keyup and submit
		 $("#frmDirectPayout").validate({
			  rules: {
				startDate:{
				  required: true,
				},
				endDate:{
				  required: true,
				}
			  },
			  messages: {
				startDate:{
				required: 'Please enter the start date.',
		    	},
				endDate:{
				  required: "Please enter the end date.",
				}
			  },
			  errorPlacement: function(label, element) {
				label.addClass('mt-2 text-danger');
				label.insertAfter(element);
			  },
			  highlight: function(element, errorClass) {
				$(element).parent().addClass('has-danger')
				$(element).addClass('form-control-danger')
			  }

			
		  });

		  if($("#frmDirectPayout").valid())
			 $("#frmDirectPayout").submit();

	  });


	  $("#frmDirectPayout").on('submit',(function(e){
			 e.preventDefault();
			 $("#loader").show();
			 $("#btnCalculate").hide();

			 $.ajax({
				type        : 'POST', 
				url         : '../API/API_Direct_Payout.php', 
				data        : new FormData(this),
				dataType    : 'json', 
				encode      :  true,
				cache		: false,
				contentType : false,
				processData : false,
				})

				.done(function(data){
				  $("#loader").hide();
				  $("#btnCalculate").show();

				  if (data.success){
					alert(data.message);
					location.href = 'admin-dashboard.php';
				  }

				  else{
					alert(data.message);
				  } 

				}) 
				
				.fail(function(data){
					$("#loader").hide();
					$("#btnCalculate").show();
					alert("Some error has occured. Please try again later!"); 
				});


		}));



</script>

