<?php

	
	include 'header.php';
	include 'navbar.php';
	include 'includes/admin_API_Config.php';

	$obj  = new API_Config;
	$data = array();
	$data['admin_username'] = $_SESSION['admin_username'];
	$response = json_decode($obj->call_API("API_Payout_List.php", $data));
	error_reporting(0);
	//var_dump($response->payoutList);
 
?>

	<div class="card">
		<div class="card-body">
        <h4 class="card-title">Calculate Payout</h4>
			<div class="row">
				<div class="col-12 table-responsive">

					<?php 
						
						$enable    = $response->payoutList[0]->status;
						$startDate = date('d-m-Y 00:00:00', strtotime($response->payoutList[0]->payout_end_date . ' + 1 days')); 
						$endDate   = date('d-m-Y 23:59:59', strtotime(date("Y/m/d") . ' - 16 days'));
		
					?>

					<div class="form-group row">
						  <div class="col-md-3">
							<label>Payout Date:</label>
							<?php if($enable){?><input class="form-control" data-inputmask="'alias': 'date'" id='payout_date'><?php }?>
						  </div>
						  <!--div class="col-md-3">
							<label>End Date:</label>
							<input class="form-control" data-inputmask="'alias': 'date'" value=<?php echo $endDate;?>>
						  </div-->
						  <div class="col-md-1">
  							<div class="moving-square-loader"  id="loader1"><span></span><span></span></div>
						  </div>
						  <div class="col-md-3">
							<br/>
							<?php if($enable){?><button type="button" class="btn btn-primary btn-fw" id="btnCalculate">Calculate</button><?php }?>
						  </div>
 		             </div>
							

				</div>
			</div>
		</div>
	</div>

	 <div class="card">
            <div class="card-body">
              <h4 class="card-title">Payout List</h4>
              <div class="row">
                <div class="col-12 table-responsive">
                  <table id="order-listing" class="table">
                    <thead>
                      <tr>
                          <th>Sr No.</th>
                          <th>Payout No</th>
                          <th>Start Date</th>
                          <th>End Date</th>
                          <!--th>Run Date</th-->
                          <th>Status</th>
	                      <th>View Report</th>
				      </tr>
                    </thead>
                    <tbody>
					<?php
						$i=0;
						foreach($response->payoutList as $row)
						{
							echo "<tr>";
							echo "<td>" . ++$i . "</td>";
							echo "<td> Payout " . $row->id . "</td>";
							echo "<td>" . date('d-m-Y H:i:s',strtotime($row->payout_start_date)) . "</td>";
							echo "<td>" . date('d-m-Y H:i:s',strtotime($row->payout_end_date))   . "</td>";
							//echo "<td>" . date('d-m-Y H:i:s',strtotime($row->payout_run_date))   . "</td>";
							echo "<td>";
							if($row->status)
								echo "Done";
							
							else
								echo "<div class=\"moving-square-loader\" id=\"loader2\"><span></span><span></span></div><button type=\"button\" class=\"btn btn-inverse-primary btn-fw\" id=\"btnRelease\" payout_id=\"" . $row->id  . "\">Release Payout</button>";


							echo "</td>";


							echo "<td><a href=\"download-payout-report.php?payout_id=". $row->id . " \" target=\"_blank\"><span class=\"tab\"><i class=\"ti-new-window\"></i></a></td>";

						}
					?>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>


 <script type="text/javascript">

   
   $(".moving-square-loader").hide();

   
   $("#btnCalculate").click(function(){
	   
	   $("#loader1").show();
	   $("#btnCalculate").hide();

   
	   var data = {'payout_date': $('#payout_date').val()};

   	    
	   $.ajax({
				type        : 'POST', 
				url         : '../API/API_Incentive_Payout.php', 
				data        : data,
				dataType    : 'json', 
				encode      : true,
				cache		: false,
		})

		
		.done(function(data){

				$("#btnCalculate").show();
			    $("#loader1").hide();
			
				if (data.success) { 
					alert(data.message);
					location.reload();
				}

				else{
					 alert(data.message);
					 location.reload();

				}

				$("#").removeAttr("disabled").css("cursor","pointer");;
		 })

		 
		 
		 .fail(function(data){
			  $("#btnCalculate").show();
			  $("#loader1").hide();
			  alert(data.message);
			  //location.reload();
			  $("#").removeAttr("disabled").css("cursor","pointer");;
		 });

   });




   $("#btnRelease").click(function(){

	   $("#loader2").show();
	   $("#btnRelease").hide();
	   
	   var data = {'payout_id': $("#btnRelease").attr('payout_id')};


	   $.ajax({
				type        : 'POST', 
				url         : '../API/API_Release_Payout.php', 
				data        : data,
				dataType    : 'json', 
				encode      : true,
				cache		: false,
	   })

		
		.done(function(data){

				$("#btnRelease").show();
			    $("#loader2").hide();
			
				if (data.success) { 
					alert(data.message);
					location.reload();
				}

				else{
					 alert(data.message);
					 location.reload();

				}

				$("#").removeAttr("disabled").css("cursor","pointer");;
		 })

		 
		 
		 .fail(function(data){
			  $("#btnRelease").show();
			  $("#loader2").hide();
			  alert(data.message);
			  //location.reload();
			  $("#").removeAttr("disabled").css("cursor","pointer");;
		 });

   });

	


 </script>



<?php
	include 'footer.php';
?>



   
