(function($) {
  'use strict';
  var form = $("#frm_reg");

  var $validator=$("#frm_reg").validate({
      rules: {
		sponsorID:{
		  required: true,
		  digits: true,
		  minlength: 9
		},
		placementID:{
		  digits: true,
		  minlength: 9
		},
        firstName: {
          required: true,
          minlength: 3
        },
        lastName: {
          required: true,
          minlength: 3
        },
	    mobileNumber:{
        required: true,
        digits: true,
	    minlength: 10,
		},
        password: {
          required: true,
          minlength: 6
        },
        confirmPassword: {
          required: true,
          minlength: 6,
          equalTo: "#password"
        },
        emailID: {
          required: true,
          email: true
        },
		txtKYC: {
          required: true,
        },
        kyc: {
          required: true,
        },
        terms: "required"
      },
      messages: {
		sponsorID:{
        required: 'Please enter a 9 digit valid sponsor id.',
        digits:   'Please enter a 9 digit valid sponsor id.',
		minlength: 'Please enter a 9 digit valid sponsor id.'
		},
		placementID:{
        digits: 'Please enter a 9 digit valid placement id.',
		minlength: 'Please enter a 9 digit valid sponsor id.'
		},
        firstName: {
          required: "Please enter a First Name",
          minlength: "First Name must consist of at least 3 characters"
        },
		lastName: {
          required: "Please enter a username",
          minlength: "Last Name must consist of at least 3 characters"
        },
	    mobile:{
          required: 'Please provide mobile number.',
          digits:'Please enter a valid mobile number.',
		  minlength: "Please enter 10 digit mobile number."
        },
        password: {
          required: "Please provide a password",
          minlength: "Your password must be at least 6 characters long"
        },
        confirmPassword: {
          required: "Please provide a password",
          minlength: "Your password must be at least 6 characters long",
          equalTo: "Please enter the same password as above"
        },
		txtKYC: {
			required: "Please enter your kyc info."
		},
		kyc: {
			required: "Please upload a file.",
		},
        emailID: "Please enter a valid email address",
        agree: "Please accept our policy",
        topic: "Please select at least 2 topics"
      },
      errorPlacement: function(label, element) {
        label.addClass('mt-2 text-danger');
        label.insertAfter(element);
      },
      highlight: function(element, errorClass) {
        $(element).parent().addClass('has-danger')
        $(element).addClass('form-control-danger')
      }

    });




  form.children("div").steps({
    headerTag: "h3",
    bodyTag: "section",
    transitionEffect: "slideLeft",
	onStepChanging: function(event, currentIndex, newIndex) {
     var valid = form.valid();
	 if(!valid) {
	    $validator.focusInvalid();
	  	return false;
	 }
	 else
		 return true;

    },
    onFinished: function(event, currentIndex) {

   if($("#frm_reg").valid())
		$("#frm_reg").submit();

    }
  });


  /*var validationForm = $("#example-validation-form");
  validationForm.val({
    errorPlacement: function errorPlacement(error, element) {
      element.before(error);
    },
    rules: {
      confirm: {
        equalTo: "#password"
      }
    }
  });


  validationForm.children("div").steps({
    headerTag: "h3",
    bodyTag: "section",
    transitionEffect: "slideLeft",
    onStepChanging: function(event, currentIndex, newIndex) {
      validationForm.val({
        ignore: [":disabled", ":hidden"]
      })
      return validationForm.val();
    },
    onFinishing: function(event, currentIndex) {
      validationForm.val({
        ignore: [':disabled']
      })
      return validationForm.val();
    },
    onFinished: function(event, currentIndex) {
      alert("Submitted!");
    }
  });


  var verticalForm = $("#example-vertical-wizard");
  verticalForm.children("div").steps({
    headerTag: "h3",
    bodyTag: "section",
    transitionEffect: "slideLeft",
    stepsOrientation: "vertical",
    onFinished: function(event, currentIndex) {
      alert("Submitted!");
    }
  });*/

   
 
	 $("#frm_reg").on('submit',(function(e){
		 e.preventDefault();
		 $("#cmbPlacement").removeAttr("disabled");
		 $("#loader_Registration").show();
		 $(".actions").hide();
         
		 $("#countryCode").val($("#mobileNumber").intlTelInput("getSelectedCountryData")['dialCode']);
		 //form_Data.append("countryCode",countryData['dialCode']);

		 $.ajax({
			type        : 'POST', 
			url         : 'registeruser.php', 
			data        : new FormData(this),
			dataType    : 'json', 
			encode      : true,
			cache		: false,
			contentType : false,
			processData : false,
			})

			.done(function(data){
			  $("#loader_Registration").hide();
			  $("#btnLogin").show();
			  $(".actions").show();


			  if (data.status){
				alert(data.message);
				location.reload();
			    //location.href = 'localhost/marvel/panel/add-new-member.php';
			  }

			  else{
				alert(data.message);
			  } 

			}) 
			
			.fail(function(data){
				$("loader_Registration").hide();
			    $("#btnLogin").show();
				alert("Some error has occured. Please try again later!"); 
			});



		}));


		if($(window).width() < 767)
		{
			$("#steps-uid-0-t-0, #steps-uid-0-t-2").click(function(){

				$(".wizard .content").css("height","24em");


			});



			$("#steps-uid-0-t-1").click(function(){

				$(".wizard .content").css("height","34em");

			});
		}
		
		

			$("a").click(function(){

				$("#frm_reg").validate();
				//alert("hI");

			});


	$("#btnReset").click(function(e){
	   
		 var login_submit = $("#frmResetPassword").validate({
		   rules:{
				resetID:{
					required: true,
					digits: true
				 },
				 resetEmail:{
					required: true,
					email: true
				  },
				  otp_received:{
					required: true,
					digits: true,
					minlength: 4,
				  }
			},       
			messages:{
			   resetID:{
					required: 'Please enter your Member ID',
					digits  : 'Please enter a valid Member ID.'
				},
				resetEmail:{
					required: 'Please enter Email ID',
					digits  : 'Please enter a valid Email ID.'
				 },
				otp_received:{
					 required: 'Please enter OTP',
					 digits:'Please enter a valid OTP.',
					 minlength:'Please enter a valid OTP.',
				 }
			 },
			
			  errorPlacement: function(label, element) {
				label.addClass('mt-2 text-danger');
				label.insertAfter(element);
			  },
			  highlight: function(element, errorClass) {
				$(element).parent().addClass('has-danger')
				$(element).addClass('form-control-danger')
			  }
		  });

		 if($("#frmResetPassword").valid())
		  $("#frmResetPassword").submit();
	  });

	 
	  $("#frmResetPassword").on('submit',(function(e){

		  $("#btnReset").attr("disabled","disabled").css("cursor","wait");
		  e.preventDefault();
		  $("#loader").show();
		  $("#btnReset").hide();

		  	 
		  var formData = {
			'memberID': $('input[name=resetID').val(),
			'emailID': $('input[name=resetEmail]').val(),
			'otpRequest': $('input[name=otp_request]').val(),
			'otp_received': $('input[name=otp_received]').val(),
		  };

		  $.ajax({
			type        : 'POST', 
			url         : 'forgot-password.php', 
			data        : formData, 
			dataType    : 'json', 
			encode      : true
		  })

		  .done(function(data){
			$("div.loader").addClass("hide");
			$("#loader").hide();
		    $("#btnReset").show();

			if (data.status==1) {  
				
				if(data.OTPResponse==true){
					  $('#displaytitle').text("Confirm OTP");
				      $("#btnReset").text("Submit OTP");
					  $('#userCredential').addClass("d-none");
					  $('#userOTP').removeClass("d-none");
				 }

				 else{
					  alert(data.message);
					  location.reload();
				 }
		
			 }

			else{
				alert(data.message);
			} 
			$("#btnReset").removeAttr("disabled").css("cursor","pointer");;
		  }) 

		  .fail(function(data){
			 $("div.loader").addClass("hide");
			 $("#btnReset").removeAttr("disabled").css("cursor","pointer");;
		  });

		   
	  }))

})(jQuery);


	
	  