<?php
	
	header('Content-Type: application/json');
	ini_set('display_startup_errors',1);
	ini_set('display_errors',1);
	error_reporting(1);
	ini_set("log_errors", 1);
	ini_set("error_log", "php-error.log");

    date_default_timezone_set('Asia/Kolkata');

	require_once("database.php");	

	$validationErr = '';
	$result = array();
	$data = array();


   if(!isset($_REQUEST['memberID']) || $_REQUEST['memberID'] == '') {		
		$validationErr = "Please enter the Member ID!";
	}
	else if(!isset($_REQUEST['orderID']) || $_REQUEST['orderID'] == '') {		
		$validationErr = "Please enter the Order Number!";
	}
   else if(!isset($_REQUEST['totalAmount']) || $_REQUEST['totalAmount'] == '') {		
		$validationErr = "Please enter the total amount!";
	} else if(!isset($_REQUEST['transactionNo']) || $_REQUEST['transactionNo'] == '') {		
		$validationErr = "Please enter the transaction number!";
	} else if(!isset($_REQUEST['chequeNo']) || $_REQUEST['chequeNo'] == '') {		
			$validationErr = "Please enter the cheque number!";
	} else if($_REQUEST['cmbBankName'] == 'Others') {
		if(!isset($_REQUEST['txtBankName']) || $_REQUEST['txtBankName'] == '') {		
			$validationErr = "Please enter the bank name!";
		}
	}



	if($validationErr != '') {

		$result = array();
		$result['status'] = '0';
		$result['message'] = $validationErr;
		print $return = json_encode($result);
		exit;

	}

	$data['refer_id']        = $_REQUEST['memberID'];
	$data['email_id']        = $_REQUEST['emailID'];
	$data['order_id']        = $_REQUEST['orderID'];
	$data['total_amount']    = $_REQUEST['totalAmount'];
	$data['payment_date']    = $_REQUEST['paymentDate'];
	$data['cheque_no']       = $_REQUEST['chequeNo'];
	$data['txn_no']          = $_REQUEST['transactionNo'];
	$data['bank_name']       = $_REQUEST['bankName'];
	$data['processing_fees'] = $_REQUEST['processingFees'];
	$data['amount_received'] = $_REQUEST['amountReceived'];
    $data['status']          = 1;

    $conn = new Database;
	$db = $conn->getConnection();
	$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);



    if(empty($_REQUEST['paymentID']))
	{
	
		if(addPaymentInfo($db, $data))
		{
			$result['success'] = true;
			$result['message'] = "Payment information for the order number have been succesfully added to our sysytem.";

		}

		else
		{
			$result['success'] = false;
			$result['message'] = "Request cannot be processed due to invalid credentials. Please contact administrator!";
		}
	}


	else
	{
		if(updatePaymentInfo($db, $_REQUEST['paymentID'], $data))
		{
			$result['success'] = true;
			$result['message'] = "Payment information for the order number have been succesfully added to our sysytem.";

		}

		else
		{
			$result['success'] = false;
			$result['message'] = "Request cannot be processed due to invalid credentials. Please contact administrator!";
		}
	}



	echo json_encode($result);




	function addPaymentInfo($db, $data)
	{
		try{
			$date = date("Y-m-d H:i:s");
			$id = $date . $order_id . mt_rand(100, 999999);
			$id = md5($id);

			$id   = substr_replace($id, "-",9,0);
			$id   = substr_replace($id, "-",14,0);
			$id   = substr_replace($id, "-",18,0);
			$id   = substr_replace($id, "-",22,0);

			$stmt 		= $db->prepare("INSERT INTO  my_payment_info(id, refer_id, email_id, order_id, total_amount, payment_date, date_entered, cheque_no, txn_no, bank_name, processing_fees, amount_received, status) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
			$stmt->execute(array($id,  $data['refer_id'], $data['email_id'], $data['order_id'], $data['total_amount'], $data['payment_date'], $date, $data['cheque_no'], $data['txn_no'], $data['bank_name'], $data['processing_fees'], $data['amount_received'], 1));

			return true;
		}


		catch(Exception $err)
		{
			echo $err->getMessage();
			return false;

		}
		
	}


	function updatePaymentInfo($db, $payment_id, $data)
	{
		
	    try 
		{
			$sql = "UPDATE my_payment_info set refer_id=?, email_id=?, order_id=?, total_amount=?, payment_date=?, cheque_no=?, txn_no=?, bank_name=?, processing_fees=?, amount_received=? where id=?";
				
			$stmt= $db->prepare($sql);
			$stmt->execute(array($data['refer_id'], $data['email_id'], $data['order_id'], $data['total_amount'], $data['payment_date'], $data['cheque_no'], $data['txn_no'], $data['bank_name'],  $data['processing_fees'], $data['amount_received'], $payment_id));

			if($stmt->execute())
			{
			  return true;
			}

		    else
		  	  return false;
		   			
		}

		catch(PDOException $ex){
			echo $ex->getMessage();
		   return false;
		}

	}
	

	


 ?>