<?php

	header('Content-Type: application/json');
	ini_set('display_startup_errors',1);
	ini_set('display_errors',1);
	error_reporting(1);
	ini_set("log_errors", 1);
	ini_set("error_log", "php-error.log");

	date_default_timezone_set('Asia/Kolkata');

	require_once("database.php");


	class ProductPurchase
	{
		private $conn;
		public  $memberID;
		public  $customerID;
		public  $productID;
		public  $productName;
		public  $productPrice;
		public  $productPV;
		public  $paidByDeposit;
		public  $paidByCash;
		public  $paidByBBT;
		public  $pvPosition;
		public  $totalPaid;

		function __Construct()
		{
			$dbconnect = new Database();
			$this->conn = $dbconnect->getConnection();
		}



		function verifyMemberID()
		{

   		  try{
				$stmt  = $this->conn->prepare("select * from my_registration where refer_id='$this->memberID'");
				$stmt->execute();
				$result = $stmt->fetch(PDO::FETCH_ASSOC);
				
				if($result)
			    {
				   $this->customerID = $result['customer_id'];
				   return true;
				}

				else
					return false;
			
			  }catch(Exception $err){

				return false;

			 } 
		 }


		 function verifyProductDetails()
		 {
			
			try{
				$stmt  = $this->conn->prepare("select * from my_product where product_id='$this->productID'");
				$stmt->execute();
				$result = $stmt->fetch(PDO::FETCH_ASSOC);
				
				if($result)
				{
					if($result['price'] <= ($this->paidByDeposit + $this->paidByCash + $this->paidByBBT))
					{
					   $this->productName  = $result['name'];
					   $this->productPrice = $result['price'];
					   $this->productPV    = $result['pricevalue'];
					   $this->totalPaid    = $this->paidByDeposit + $this->paidByCash + $this->paidByBBT;
           	 		   return true;
					}

					else
						return false;
				
				}
				else
					return false;
			
			  }catch(Exception $err){

				return false;

			 } 

		   }


		   function verifyPVPosition()
		   {
			   try{
					$stmt  = $this->conn->prepare("select count(refer_id) as packageCount from my_member_package where refer_id='$this->memberID'");
					$stmt->execute();
					$result = $stmt->fetch(PDO::FETCH_ASSOC);
					
					if($result['packageCount'])
					{
						if($result['packageCount']>0 && $result['packageCount']<3)
							return true;

						else
							return false;
					
					}

					else
						return false;
			
				}catch(Exception $err){

					return false;

				} 

		    }


			function makePurchase()
		    {

				 try{
						
						$stmt  = $this->conn->prepare("INSERT INTO my_member_package(name, refer_id, date_entered, customer_id, deleted, product_id, product_price, total_PV, paid_by_online, order_id, online_TransactionID, paid_by_voucher, paid_by_deposit, paid_by_cash, paid_by_BBT, total_tax, total_paid, user_add, payment_mode, payment_status, upload_volume, add_position) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

						$stmt->execute(array($this->productName, $this->memberID, date("Y-m-d H:i:s"), $this->customerID, '0', $this->productID, $this->productPrice, $this->productPV, '0', md5(time()), '0', '0', $this->paidByDeposit, $this->paidByCash, $this->paidByBBT, '0', $this->totalPaid, '0', '3', '1', '0', $this->pvPosition));

						return true;
			
				  }catch(Exception $err){
					  echo $err->getMessage();
					  return false;
				  } 


			   } 


   }


	$result = array();

	if(!isset($_REQUEST['memberID']) || $_REQUEST['memberID'] == '') {
		$validationErr = "Please enter a Member ID!";
	}else if(!isset($_REQUEST['cmbProduct']) || $_REQUEST['cmbProduct'] == '') {
		$validationErr = "Please select a product to purchase!";
	}else if(!isset($_REQUEST['paidByDeposit']) || $_REQUEST['paidByDeposit'] == '') {
		$validationErr = "Please enter an amount paid by deposit!";
	}else if(!isset($_REQUEST['paidByCash']) || $_REQUEST['paidByCash'] == '') {
		$validationErr = "Please enter an amount paid by cash!";
	}else if(!isset($_REQUEST['paidByBBT']) || $_REQUEST['paidByBBT'] == '') {
		$validationErr = "Please enter an amount paid by BBT!";
	}



	if($validationErr != '') {

		$result = array();
		$result['status'] = '0';
		$result['message'] = $validationErr;
		print $return = json_encode($result);
		exit;

	} 

	
	
	
	
	$product				= new ProductPurchase();
	$product->memberID		= $_REQUEST['memberID'];
	$product->productID		= $_REQUEST['cmbProduct'];
	$product->paidByDeposit = $_REQUEST['paidByDeposit'];
	$product->paidByCash	= $_REQUEST['paidByCash'];
	$product->paidByBBT		= $_REQUEST['paidByBBT'];
	$product->pvPosition	= $_REQUEST['cmbPosition'];



	if($product->verifyMemberID())
	{
		if($product->verifyProductDetails())
		{
			if($product->pvPosition>0)
			{
				if(!$product->verifyPVPosition())
				{
					$result['success'] = false;
					$result['message'] = "You cannot specify position for this purchase!";
					echo json_encode($result);
					exit;
			 	}
			 }

			 if($product->makePurchase())
			 {
				 $result['success'] = true;
		         $result['message'] = "Member Package bought Successfully!";
			 }

			 else
			 {
				 $result['success'] = false;
		         $result['message'] = "Your request failed! Please try after sometime!";
			 }


		}

		else
		{
			$result['success'] = false;
		    $result['message'] = "Improper Product Details. Purchase cannot be processed!";

    	}

	}

	else
	{
		$result['success'] = false;
		$result['message'] = "Member Id doesn't exist!";
	}



	echo json_encode($result);



?>

