<?php

	header('Content-Type: application/json');
	ini_set('display_startup_errors',1);
	ini_set('display_errors',1);
	error_reporting(1);
	ini_set("log_errors", 1);
	ini_set("error_log", "php-error.log");
	ini_set('set_time_limit', 0);
	ini_set('memory_limit','1000000000000M');
	date_default_timezone_set('Asia/Kolkata');

	$data = json_decode(trim(file_get_contents("php://input")),true);
	$_REQUEST['referID'] = $data['referID'];
	//$_REQUEST['referID'] = '233791797';
	//$_REQUEST['referID'] = '909378288';
	//$_REQUEST['referID'] = '375975558';
	$_REQUEST['leg']  = $data['leg'];
	$_REQUEST['type'] = $data['type'];
	

	$validationErr = '';
	if(!isset($_REQUEST['referID'])){
		$validationErr = "Member ID Invalid!";
	}

	if($validationErr != ''){

		$result = array();
		$result['success'] = false;
		$result['message'] = $validationErr;
		print $return = json_encode($result);
		exit;

	}

	require_once("database.php");

	class NetworkExplorer
	{
		private $conn;
    	public  $memberID;
		public  $leftMembers;
		public  $rightMembers;
		public  $memberInfo;
		public  $packageInfo ;
		public  $leftPaid;
		public  $rightPaid;
		public  $members;
		public	$leg;
		public  $type;
		

		function __Construct()
		{
			$dbconnect = new Database();
			$this->conn = $dbconnect->getConnection();
			
		}

		function Network_List()
		{

			try{

				$sql = "SELECT * from my_network where refer_id = '$this->memberID'";
				$stmt= $this->conn->prepare($sql);
				$stmt->execute();
				$result = $stmt->fetchAll(PDO::FETCH_ASSOC);
				return $result;
			}

			catch(Exception $e)
			{
				$e->getMessage();
				return false;

			}

		}


		function Member_Info($referID)
		{

			try{

				$sql = "SELECT concat(name, ' ' , last_name) as name, refer_id from my_registration where refer_id = '$referID' AND deleted = 0";
				$stmt= $this->conn->prepare($sql);
				$stmt->execute();
				$result = $stmt->fetch(PDO::FETCH_ASSOC);
				//var_dump($result);
				return $result;
			}

			catch(Exception $e)
			{
				$e->getMessage();
				return false;
			}

		}


		function Package_Info($referID)
		{

			try{

				$sql = "SELECT date_format(date_entered, '%d-%m-%Y') as purchase_date, sum(total_PV) as purchase from my_member_package where refer_id = '$referID' AND deleted = 0 order by date_entered ASC";
				$stmt= $this->conn->prepare($sql);
				$stmt->execute();
				$result = $stmt->fetch(PDO::FETCH_ASSOC);
				//var_dump($result);
				return $result;
			}

			catch(Exception $e)
			{
				$e->getMessage();
				return false;
			}

		}


		function Get_All_Members()
		{
			$result =array();
			$result = $this->Network_List();
			$this->leftMembers  = explode(",", rtrim($result[0]["leftNetwork"], ','));
			$this->rightMembers = explode(",", rtrim($result[0]["rightNetwork"], ','));

			$i=0;	
			if(!empty($this->leftMembers))
			{

				foreach($this->leftMembers as $row)
				{
					$this->memberInfo  = $this->Member_Info($row);
					$this->packageInfo = $this->Package_Info($row);
					$this->members[$i]['name']	   = $this->memberInfo['name'];
					$this->members[$i]['refer_id'] = $this->memberInfo['refer_id'];
					$this->members[$i]['purchase'] = $this->packageInfo['purchase'];
					$this->members[$i]['purchase_date'] = $this->packageInfo['purchase_date'];	
					$this->members[$i]['leg'] = 0;
					if((!empty($this->packageInfo['purchase'])) && $this->packageInfo['purchase']>0)
						$this->leftPaid++;

					$i++;
				}
			}


			if(!empty($this->rightMembers))
			{
				$i=0;
				foreach($this->rightMembers as $row)
				{
					$this->memberInfo  = $this->Member_Info($row);
					$this->packageInfo = $this->Package_Info($row);
					$this->members[$i]['name']	 = $this->memberInfo['name'];
					$this->members[$i]['refer_id'] = $this->memberInfo['refer_id'];
					$this->members[$i]['purchase'] = $this->packageInfo['purchase'];
					$this->members[$i]['purchase_date'] = $this->packageInfo['purchase_date'];
					$this->members[$i]['leg'] = 1;
					if((!empty($this->packageInfo['purchase'])) && $this->packageInfo['purchase']>0)
						$this->rightPaid++;

					$i++;
				}
			}

			return $this->members;
	

		}


		function Get_Left_Members()
		{
			$result =array();
			$result = $this->Network_List();
			$this->leftMembers  = explode(",", rtrim($result[0]["leftNetwork"], ','));

			if(!empty($this->leftMembers))
			{

				if($this->type=='total')
				{		
					$i=0;			
					foreach($this->leftMembers as $row)
					{
						$this->memberInfo  = $this->Member_Info($row);
						$this->packageInfo = $this->Package_Info($row);
						$this->members[$i]['name']	 = $this->memberInfo['name'];
						$this->members[$i]['refer_id'] = $this->memberInfo['refer_id'];
						$this->members[$i]['purchase'] = $this->packageInfo['purchase'];
						$this->members[$i]['purchase_date'] = $this->packageInfo['purchase_date'];	
						$this->members[$i]['leg'] = 0;
						if((!empty($this->packageInfo['purchase'])) && $this->packageInfo['purchase']>0)
							$this->leftPaid++;
						$i++;
					}
				}


				else
				{		
					$i=0;			
					foreach($this->leftMembers as $row)
					{
						$this->memberInfo  = $this->Member_Info($row);
						$this->packageInfo = $this->Package_Info($row);

						if($this->type=='paid')
						{
							if((!empty($this->packageInfo['purchase'])) && $this->packageInfo['purchase']>0)
							{
								$this->members[$i]['name']	 = $this->memberInfo['name'];
								$this->members[$i]['refer_id'] = $this->memberInfo['refer_id'];
								$this->members[$i]['purchase'] = $this->packageInfo['purchase'];
								$this->members[$i]['purchase_date'] = $this->packageInfo['purchase_date'];	
								$this->members[$i]['leg'] = 0;
								$this->leftPaid++;
								$i++;
							}
						}

						else
						{
							if(empty($this->packageInfo['purchase']))
							{
								$this->members[$i]['name']	 = $this->memberInfo['name'];
								$this->members[$i]['refer_id'] = $this->memberInfo['refer_id'];
								$this->members[$i]['purchase'] = $this->packageInfo['purchase'];
								$this->members[$i]['purchase_date'] = $this->packageInfo['purchase_date'];	
								$this->members[$i]['leg'] = 0;
								$i++;
							}

						}
					}
				 }
			}

			return $this->members;

		}


		function Get_Right_Members()
		{
			$result =array();
			$result = $this->Network_List();
			$this->rightMembers = explode(",", rtrim($result[0]["rightNetwork"], ','));

			if(!empty($this->rightMembers))
			{

				if($this->type=='total')
				{		
					$i=0;
					foreach($this->rightMembers as $row)
					{
						$this->memberInfo  = $this->Member_Info($row);
						$this->packageInfo = $this->Package_Info($row);
						$this->members[$i]['name']	 = $this->memberInfo['name'];
						$this->members[$i]['refer_id'] = $this->memberInfo['refer_id'];
						$this->members[$i]['purchase'] = $this->packageInfo['purchase'];
						$this->members[$i]['purchase_date'] = $this->packageInfo['purchase_date'];
						$this->members[$i]['leg'] = 1;
						if((!empty($this->packageInfo['purchase'])) && $this->packageInfo['purchase']>0)
							$this->rightPaid++;

						$i++;
					}
				}


				else
				{
						
					$i=0;			
					foreach($this->rightMembers as $row)
					{
						$this->memberInfo  = $this->Member_Info($row);
						$this->packageInfo = $this->Package_Info($row);

						if($this->type=='paid')
						{
							if((!empty($this->packageInfo['purchase'])) && $this->packageInfo['purchase']>0)
							{
								$this->members[$i]['name']	 = $this->memberInfo['name'];
								$this->members[$i]['refer_id'] = $this->memberInfo['refer_id'];
								$this->members[$i]['purchase'] = $this->packageInfo['purchase'];
								$this->members[$i]['purchase_date'] = $this->packageInfo['purchase_date'];	
								$this->members[$i]['leg'] = 1;
								$this->leftPaid++;
								$i++;
							}
						}

						else
						{
							if(empty($this->packageInfo['purchase']))
							{
								$this->members[$i]['name']	 = $this->memberInfo['name'];
								$this->members[$i]['refer_id'] = $this->memberInfo['refer_id'];
								$this->members[$i]['purchase'] = $this->packageInfo['purchase'];
								$this->members[$i]['purchase_date'] = $this->packageInfo['purchase_date'];	
								$this->members[$i]['leg'] = 1;
								$i++;
							}

						}
					}
				}
			}

			return $this->members;

		}




	}


	$obj = new NetworkExplorer();
	$obj->memberID = $_REQUEST['referID'];
	$obj->leg  = $_REQUEST['leg'];
	$obj->type = $_REQUEST['type'];
	
	$data			 = array();
	$members		 = array();
	$data['status']	 = 1;
	$data['message'] = 'Success';

	if(empty($obj->leg))
		$data['members'] = $obj->Get_All_Members();
	
	else if($obj->leg == 'l')
		$data['members'] = $obj->Get_Left_Members();

	else
		$data['members'] = $obj->Get_Right_Members();


	$data['leftCount']  = count($obj->leftMembers);
	$data['rightCount'] = count($obj->rightMembers);
	$data['leftPaid']   = $obj->leftPaid;
	$data['rightPaid']  = $obj->rightPaid;

	echo json_encode($data);

?>
