<?php

	header('Content-Type: application/json');
	ini_set('display_startup_errors',1);
	ini_set('display_errors',1);
	error_reporting(1);
	ini_set("log_errors", 1);
	ini_set("error_log", "php-error.log");
	date_default_timezone_set('Asia/Kolkata');

	require_once("database.php");
    $data = json_decode(trim(file_get_contents("php://input")),true);


	class RewardReport
	{
		private $conn;
		public  $referID;
		private $regdDate;
		private $claimedLeftVolume;
		private $claimedRightVolume;


		function __Construct()
		{
			$dbconnect  = new Database();
			$this->conn = $dbconnect->getConnection();
		}

		function getRegistrationDate()
		{

		   try{

				$stmt  = $this->conn->prepare("SELECT date_entered from my_member_package where refer_id='$this->referID' order by date_entered ASC");
				$stmt->execute();
				$result = $stmt->fetch(PDO::FETCH_ASSOC);
			 	$this->regdDate = $result['date_entered'];
			 	//$this->regdDate = '2018-02-11 23:59:59';
			
			  }catch(Exception $err){
				return 0;
		   } 
		
		}


	
		function getReward1Status()
		{
			$rewardID       = 1;
			$rewardDuration = '26';
			$rewardName     = 'Emerald';
			$leftLegTarget  = 1500000;
			$rightLegTarget = 1500000;


			try{

				$data = array();

				$closingDate = date('Y-m-d 23:59:59', strtotime($this->regdDate . ' + ' .  ($rewardDuration * 7) . ' days'));
				$date1       = new DateTime($closingDate);
				$date2       = new DateTime(date('Y-m-d 23:59:59'));
				$diff        = date_diff($date1,$date2);
			    $daysLeft = $date2->diff($date1)->format('%R%a');

				//Get Left PV
				$stmt2 = $this->conn->prepare("SELECT sum(pv) as total_PV from my_payout_child where date_time<=? AND sponsored_id=? AND node='l'");

				//Get Right PV
				$stmt3 = $this->conn->prepare("SELECT sum(pv) as total_PV from my_payout_child where date_time<=? AND sponsored_id=? AND node='r'");

				$stmt2->execute(array($closingDate, $this->referID));
				$stmt3->execute(array($closingDate, $this->referID));

				$result2 = $stmt2->fetch(PDO::FETCH_ASSOC);
				$result3 = $stmt3->fetch(PDO::FETCH_ASSOC);

				$leftVolume  =  $result2['total_PV'];
				$rightVolume =  $result3['total_PV'];

				
				$data['rewardID']          = $rewardID;
				$data['rewardDuration']    = $rewardDuration;
				$data['rewardName']        = $rewardName;
				$data['leftLegTarget']     = $leftLegTarget;
				$data['rightLegTarget']    = $rightLegTarget;
				$data['rewardLeftVolume']  = $leftVolume;
				$data['rewardRightVolume'] = $rightVolume;
				$data['daysLeft']          = $daysLeft;


			 	return $data;
			
			}catch(Exception $err){
				return 0;
			} 



		}



		function getReward2Status()
		{
			$rewardID       = 2;
			$rewardDuration = '52';
			$rewardName     = 'Silver';
			$leftLegTarget  = 7500000;
			$rightLegTarget = 7500000;

			try{

				$data = array();

				$closingDate = date('Y-m-d 23:59:59', strtotime($this->regdDate . ' + ' .  ($rewardDuration * 7) . ' days'));
				$date1       = new DateTime($closingDate);
				$date2       = new DateTime(date('Y-m-d 23:59:59'));
				$diff        = date_diff($date1,$date2);
			    $daysLeft = $date2->diff($date1)->format('%R%a');

				//Get Left PV
				$stmt2 = $this->conn->prepare("SELECT sum(pv) as total_PV from my_payout_child where date_time<=? AND sponsored_id=? AND node='l'");

				//Get Right PV
				$stmt3 = $this->conn->prepare("SELECT sum(pv) as total_PV from my_payout_child where date_time<=? AND sponsored_id=? AND node='r'");

				$stmt2->execute(array($closingDate, $this->referID));
				$stmt3->execute(array($closingDate, $this->referID));

				$result2 = $stmt2->fetch(PDO::FETCH_ASSOC);
				$result3 = $stmt3->fetch(PDO::FETCH_ASSOC);

				$leftVolume  =  $result2['total_PV'];
				$rightVolume =  $result3['total_PV'];

				
				$data['rewardID']          = $rewardID;
				$data['rewardDuration']    = $rewardDuration;
				$data['rewardName']        = $rewardName;
				$data['leftLegTarget']     = $leftLegTarget;
				$data['rightLegTarget']    = $rightLegTarget;
				$data['rewardLeftVolume']  = $leftVolume;
				$data['rewardRightVolume'] = $rightVolume;
				$data['daysLeft']          = $daysLeft;


			 	return $data;
			
			}catch(Exception $err){
				return 0;
			} 




		}




		function getReward3Status()
		{
			$rewardID       = 3;
			$rewardDuration = '78';
			$rewardName     = 'Gold';
			$leftLegTarget  = 22500000;
			$rightLegTarget = 22500000;


			try{

				$data = array();

				$closingDate = date('Y-m-d 23:59:59', strtotime($this->regdDate . ' + ' .  ($rewardDuration * 7) . ' days'));
				$date1       = new DateTime($closingDate);
				$date2       = new DateTime(date('Y-m-d 23:59:59'));
				$diff        = date_diff($date1,$date2);
			    $daysLeft = $date2->diff($date1)->format('%R%a');

				//Get Left PV
				$stmt2 = $this->conn->prepare("SELECT sum(pv) as total_PV from my_payout_child where date_time<=? AND sponsored_id=? AND node='l'");

				//Get Right PV
				$stmt3 = $this->conn->prepare("SELECT sum(pv) as total_PV from my_payout_child where date_time<=? AND sponsored_id=? AND node='r'");

				$stmt2->execute(array($closingDate, $this->referID));
				$stmt3->execute(array($closingDate, $this->referID));

				$result2 = $stmt2->fetch(PDO::FETCH_ASSOC);
				$result3 = $stmt3->fetch(PDO::FETCH_ASSOC);

				$leftVolume  =  $result2['total_PV'];
				$rightVolume =  $result3['total_PV'];

				
				$data['rewardID']          = $rewardID;
				$data['rewardDuration']    = $rewardDuration;
				$data['rewardName']        = $rewardName;
				$data['leftLegTarget']     = $leftLegTarget;
				$data['rightLegTarget']    = $rightLegTarget;
				$data['rewardLeftVolume']  = $leftVolume;
				$data['rewardRightVolume'] = $rightVolume;
				$data['daysLeft']          = $daysLeft;


			 	return $data;
			
			}catch(Exception $err){
				return 0;
			} 



		}



		function getReward4Status()
		{
			$rewardID       = 4;
			$rewardDuration = '91';
			$rewardName     = 'Titanium';
			$leftLegTarget  = 37500000;
			$rightLegTarget = 37500000;

			try{

				$data = array();

				$closingDate = date('Y-m-d 23:59:59', strtotime($this->regdDate . ' + ' .  ($rewardDuration * 7) . ' days'));
				$date1       = new DateTime($closingDate);
				$date2       = new DateTime(date('Y-m-d 23:59:59'));
				$diff        = date_diff($date1,$date2);
			    $daysLeft = $date2->diff($date1)->format('%R%a');

				//Get Left PV
				$stmt2 = $this->conn->prepare("SELECT sum(pv) as total_PV from my_payout_child where date_time<=? AND sponsored_id=? AND node='l'");

				//Get Right PV
				$stmt3 = $this->conn->prepare("SELECT sum(pv) as total_PV from my_payout_child where date_time<=? AND sponsored_id=? AND node='r'");

				$stmt2->execute(array($closingDate, $this->referID));
				$stmt3->execute(array($closingDate, $this->referID));

				$result2 = $stmt2->fetch(PDO::FETCH_ASSOC);
				$result3 = $stmt3->fetch(PDO::FETCH_ASSOC);

				$leftVolume  =  $result2['total_PV'];
				$rightVolume =  $result3['total_PV'];

				
				$data['rewardID']          = $rewardID;
				$data['rewardDuration']    = $rewardDuration;
				$data['rewardName']        = $rewardName;
				$data['leftLegTarget']     = $leftLegTarget;
				$data['rightLegTarget']    = $rightLegTarget;
				$data['rewardLeftVolume']  = $leftVolume;
				$data['rewardRightVolume'] = $rightVolume;
    			$data['daysLeft']          = $daysLeft;


			 	return $data;
			
			}catch(Exception $err){
				return 0;
			} 



		}


		function getReward5Status()
		{
			$rewardID       = 5;
			$rewardDuration = '104';
			$rewardName     = 'Paltinum';
			$leftLegTarget  = 75000000;
			$rightLegTarget = 75000000;

			try{

				$data = array();

				$closingDate = date('Y-m-d 23:59:59', strtotime($this->regdDate . ' + ' .  ($rewardDuration * 7) . ' days'));
				$date1       = new DateTime($closingDate);
				$date2       = new DateTime(date('Y-m-d 23:59:59'));
				$diff        = date_diff($date1,$date2);
			    $daysLeft    = $date2->diff($date1)->format('%R%a');

				//Get Left PV
				$stmt2 = $this->conn->prepare("SELECT sum(pv) as total_PV from my_payout_child where date_time<=? AND sponsored_id=? AND node='l'");

				//Get Right PV
				$stmt3 = $this->conn->prepare("SELECT sum(pv) as total_PV from my_payout_child where date_time<=? AND sponsored_id=? AND node='r'");

				$stmt2->execute(array($closingDate, $this->referID));
				$stmt3->execute(array($closingDate, $this->referID));

				$result2 = $stmt2->fetch(PDO::FETCH_ASSOC);
				$result3 = $stmt3->fetch(PDO::FETCH_ASSOC);

				$leftVolume  =  $result2['total_PV'];
				$rightVolume =  $result3['total_PV'];

				
				$data['rewardID']          = $rewardID;
				$data['rewardDuration']    = $rewardDuration;
				$data['rewardName']        = $rewardName;
				$data['leftLegTarget']     = $leftLegTarget;
				$data['rightLegTarget']    = $rightLegTarget;
				$data['rewardLeftVolume']  = $leftVolume;
				$data['rewardRightVolume'] = $rightVolume;
    			$data['daysLeft']          = $daysLeft;


			 	return $data;
			
			}catch(Exception $err){
				return 0;
			} 

		}



		function getReward6Status()
		{
			$rewardID       = 6;
			$rewardDuration = '104';
			$rewardName     = 'Double Platinum';
			$leftLegTarget  = 150000000;
			$rightLegTarget = 150000000;

			try{

				$data = array();

				$closingDate = date('Y-m-d 23:59:59', strtotime($this->regdDate . ' + ' .  ($rewardDuration * 7) . ' days'));
				$date1       = new DateTime($closingDate);
				$date2       = new DateTime(date('Y-m-d 23:59:59'));
				$diff        = date_diff($date1,$date2);
			    $daysLeft    = $date2->diff($date1)->format('%R%a');

				//Get Left PV
				$stmt2 = $this->conn->prepare("SELECT sum(pv) as total_PV from my_payout_child where date_time<=? AND sponsored_id=? AND node='l'");

				//Get Right PV
				$stmt3 = $this->conn->prepare("SELECT sum(pv) as total_PV from my_payout_child where date_time<=? AND sponsored_id=? AND node='r'");

				$stmt2->execute(array($closingDate, $this->referID));
				$stmt3->execute(array($closingDate, $this->referID));

				$result2 = $stmt2->fetch(PDO::FETCH_ASSOC);
				$result3 = $stmt3->fetch(PDO::FETCH_ASSOC);

				$leftVolume  =  $result2['total_PV'];
				$rightVolume =  $result3['total_PV'];

				
				$data['rewardID']          = $rewardID;
				$data['rewardDuration']    = $rewardDuration;
				$data['rewardName']        = $rewardName;
				$data['leftLegTarget']     = $leftLegTarget;
				$data['rightLegTarget']    = $rightLegTarget;
				$data['rewardLeftVolume']  = $leftVolume;
				$data['rewardRightVolume'] = $rightVolume;
    			$data['daysLeft']          = $daysLeft;


			 	return $data;
			
			}catch(Exception $err){
				return 0;
			} 

		}





	
		
	}


	if(empty($data['refer_id']))
	{
		$result = array();
		$result['success'] = true;
		$result['message'] = 'Kindly mention the Member ID!';
		echo json_encode($result);
		exit;
	}


	$result               = array();
	$rewardObj            = new RewardReport();
	//$rewardObj->referID   = '909378288';
	$rewardObj->referID   = $data['refer_id'];
	$rewardObj->getRegistrationDate();
	$result['success'] = true;
	$result['message'] = "Payout List";
	$result['data'][0] = $rewardObj->getReward1Status();
	$result['data'][1] = $rewardObj->getReward2Status();
	$result['data'][2] = $rewardObj->getReward3Status();
	$result['data'][3] = $rewardObj->getReward4Status();
	$result['data'][4] = $rewardObj->getReward5Status();
	$result['data'][5] = $rewardObj->getReward6Status();

	echo json_encode($result);



?>

