<?php
	
	header('Content-Type: application/json');
	ini_set('display_startup_errors',1);
	ini_set('display_errors',1);
	error_reporting(1);
	ini_set("log_errors", 1);
	ini_set("error_log", "php-error.log");

    date_default_timezone_set('Asia/Kolkata');

	require_once("database.php");	

	$validationErr = '';
	$result = array();
	$data = array();

    if(!isset($_REQUEST['order_id']) || $_REQUEST['order_id'] == '') {		
		$validationErr = "Order ID is missing. Request Failed!";
	} else if(!isset($_REQUEST['txtAmount']) || $_REQUEST['txtAmount'] == '') {		
		$validationErr = "Please enter the paid amount!";
	} else if(!isset($_REQUEST['txtTransactionNo']) || $_REQUEST['txtTransactionNo'] == '') {		
		$validationErr = "Please enter the transaction number!";
	} else if($_REQUEST['cmbPaymentMode'] == 'Cheque') {
		if(!isset($_REQUEST['txtChequeNo']) || $_REQUEST['txtChequeNo'] == '') {		
			$validationErr = "Please enter the cheque number!";
		}
	} else if($_REQUEST['cmbBankName'] == 'Others') {
		if(!isset($_REQUEST['txtBankName']) || $_REQUEST['txtBankName'] == '') {		
			$validationErr = "Please enter the bank name!";
		}
	}



	if($validationErr != '') {

		$result = array();
		$result['status'] = '0';
		$result['message'] = $validationErr;
		print $return = json_encode($result);
		exit;

	}

	$data['refer_id']      = $_REQUEST['refer_id'];
	$data['order_id']      = $_REQUEST['order_id'];
	$data['paymentType']   = $_REQUEST['paymentType'];
	$data['amount']        = $_REQUEST['txtAmount'];
	$data['paymentMode']   = $_REQUEST['cmbPaymentMode'];
	$data['transactionNo'] = $_REQUEST['txtTransactionNo'];
	$data['chequeNo']      = $_REQUEST['txtChequeNo'];
	$data['bankName']      = $_REQUEST['txtBankName'];
	$data['description']   = $_REQUEST['paymentRemark'];
	$data['modeType']      = '';

    if($paymentMode=="Cheque")
		$data['$modeType'] = $_REQUEST['chequeDeposit'];


    $conn = new Database;
	$db = $conn->getConnection();
	$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

	$id = verifyOrder($db, $data['order_id'], $data['refer_id']);


	if(!empty($id))
	{
		if(addPaymentInfo($db, $data))
		{
			if(update_Member_Package($db, $data['order_id'], $data['transactionNo']))
			{
				$result['success'] = true;
				$result['message'] = "Payment information for your purchase have been succesfully added to our sysytem.";
			}

			else
			{
				$result['success'] = false;
				$result['message'] = "Request cannot be processed due to invalid credentials. Please contact administrator!";
			}

		}

		else
		{
			$result['success'] = false;
			$result['message'] = "Request cannot be processed due to invalid credentials. Please contact administrator!";
		}



	}

	else
	{
		$result['success'] = false;
		$result['message'] = "Request cannot be processed due to invalid credentials. Please contact administrator!";
	}


	echo json_encode($result);


	function verifyOrder($db, $order_id, $refer_id)
	{
		$sqlSelect 	= "SELECT id FROM my_member_package WHERE refer_id='$refer_id' && order_id='$order_id' && payment_status='0'";
		$stmt 		= $db->prepare($sqlSelect);
		$stmt->execute();
		$result = $stmt->fetch(PDO::FETCH_ASSOC);
		return $result['id'];
	}


	function addPaymentInfo($db, $data)
	{
		try{
			$date = date("Y-m-d H:i:s");
			$id = $date . $order_id . mt_rand(100, 999999);
			$id = md5($id);

			$id   = substr_replace($id, "-",9,0);
			$id   = substr_replace($id, "-",14,0);
			$id   = substr_replace($id, "-",18,0);
			$id   = substr_replace($id, "-",22,0);

			$stmt 		= $db->prepare("INSERT INTO my_member_package_payment(id, order_id, refer_id, payment_type, amount, payment_mode, mode_type, transaction_id, cheque_no, bank_name, date_entered, date_modified, description) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
			$stmt->execute(array($id,  $data['order_id'], $data['refer_id'], $data['paymentType'], $data['amount'], $data['paymentMode'], $data['modeType'], $data['transactionNo'], $data['chequeNo'], $data['bankName'], $date, $date, $data['description']));

			return true;
		}


		catch(Exception $err)
		{
			echo $err->getMessage();
			return false;

		}
		
	}




	
	
	
	
	
	function update_Member_Package($db, $order_id, $transactionNo)
	{
		
	    try 
		{
			$data = [
				'transactionNo' => $transactionNo,
				'order_id' => $order_id
			];

			$sql = "UPDATE my_member_package set deposit_slip=:transactionNo where order_id=:order_id";
		
			$stmt= $db->prepare($sql);
			$stmt->execute($data);

			if($stmt->execute())
			{
			  return true;
			}

		    else
		  	  return false;
		   			
		}

		catch(PDOException $ex){
		   return false;
		}

	}
	

	


 ?>